// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the last time that an IAM role was used. This includes the
 * date and time and the Region in which the role was last used. Activity is only reported for
 * the trailing 400 days. This period can be shorter if your Region began supporting these
 * features within the last year. The role might have been used more than 400 days ago. For
 * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked in the IAM User
 * Guide.
 * This data type is returned as a response element in the GetRole and
 * GetAccountAuthorizationDetails operations.
 */
class RoleLastUsed private constructor(builder: Builder) {
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format that the role was last used.
     * This field is null if the role has not been used within the IAM tracking period. For
     * more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked in the IAM User Guide.
     */
    val lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUsedDate
    /**
     * The name of the Amazon Web Services Region in which the role was last used.
     */
    val region: kotlin.String? = builder.region

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.RoleLastUsed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleLastUsed(")
        append("lastUsedDate=$lastUsedDate,")
        append("region=$region)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUsedDate?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleLastUsed

        if (lastUsedDate != other.lastUsedDate) return false
        if (region != other.region) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.RoleLastUsed = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format that the role was last used.
         * This field is null if the role has not been used within the IAM tracking period. For
         * more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked in the IAM User Guide.
         */
        var lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Web Services Region in which the role was last used.
         */
        var region: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.RoleLastUsed) : this() {
            this.lastUsedDate = x.lastUsedDate
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.RoleLastUsed = RoleLastUsed(this)
    }
}
