// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a server certificate without its certificate body,
 * certificate chain, and private key.
 * This data type is used as a response element in the UploadServerCertificate and ListServerCertificates
 * operations.
 */
class ServerCertificateMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) specifying the server certificate. For more information
     * about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date on which the certificate is set to expire.
     */
    val expiration: aws.smithy.kotlin.runtime.time.Instant? = builder.expiration
    /**
     * The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val path: kotlin.String? = builder.path
    /**
     * The stable and unique string identifying the server certificate. For more information
     * about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the IAM User Guide.
     */
    val serverCertificateId: kotlin.String? = builder.serverCertificateId
    /**
     * The name that identifies the server certificate.
     */
    val serverCertificateName: kotlin.String? = builder.serverCertificateName
    /**
     * The date when the server certificate was uploaded.
     */
    val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificateMetadata(")
        append("arn=$arn,")
        append("expiration=$expiration,")
        append("path=$path,")
        append("serverCertificateId=$serverCertificateId,")
        append("serverCertificateName=$serverCertificateName,")
        append("uploadDate=$uploadDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateId?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateName?.hashCode() ?: 0)
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificateMetadata

        if (arn != other.arn) return false
        if (expiration != other.expiration) return false
        if (path != other.path) return false
        if (serverCertificateId != other.serverCertificateId) return false
        if (serverCertificateName != other.serverCertificateName) return false
        if (uploadDate != other.uploadDate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) specifying the server certificate. For more information
         * about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var arn: kotlin.String? = null
        /**
         * The date on which the certificate is set to expire.
         */
        var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var path: kotlin.String? = null
        /**
         * The stable and unique string identifying the server certificate. For more information
         * about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the IAM User Guide.
         */
        var serverCertificateId: kotlin.String? = null
        /**
         * The name that identifies the server certificate.
         */
        var serverCertificateName: kotlin.String? = null
        /**
         * The date when the server certificate was uploaded.
         */
        var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata) : this() {
            this.arn = x.arn
            this.expiration = x.expiration
            this.path = x.path
            this.serverCertificateId = x.serverCertificateId
            this.serverCertificateName = x.serverCertificateName
            this.uploadDate = x.uploadDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = ServerCertificateMetadata(this)
    }
}
