// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of a service-specific credential.
 */
class ServiceSpecificCredential private constructor(builder: Builder) {
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the service-specific credential were created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The name of the service associated with the service-specific credential.
     */
    val serviceName: kotlin.String? = builder.serviceName
    /**
     * The generated password for the service-specific credential.
     */
    val servicePassword: kotlin.String? = builder.servicePassword
    /**
     * The unique identifier for the service-specific credential.
     */
    val serviceSpecificCredentialId: kotlin.String? = builder.serviceSpecificCredentialId
    /**
     * The generated user name for the service-specific credential. This value is generated by
     * combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
     * jane-at-123456789012, for example. This value cannot be configured by the
     * user.
     */
    val serviceUserName: kotlin.String? = builder.serviceUserName
    /**
     * The status of the service-specific credential. Active means that the key is
     * valid for API calls, while Inactive means it is not.
     */
    val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The name of the IAM user associated with the service-specific credential.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredential = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceSpecificCredential(")
        append("createDate=$createDate,")
        append("serviceName=$serviceName,")
        append("servicePassword=*** Sensitive Data Redacted ***,")
        append("serviceSpecificCredentialId=$serviceSpecificCredentialId,")
        append("serviceUserName=$serviceUserName,")
        append("status=$status,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createDate?.hashCode() ?: 0
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (servicePassword?.hashCode() ?: 0)
        result = 31 * result + (serviceSpecificCredentialId?.hashCode() ?: 0)
        result = 31 * result + (serviceUserName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceSpecificCredential

        if (createDate != other.createDate) return false
        if (serviceName != other.serviceName) return false
        if (servicePassword != other.servicePassword) return false
        if (serviceSpecificCredentialId != other.serviceSpecificCredentialId) return false
        if (serviceUserName != other.serviceUserName) return false
        if (status != other.status) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredential = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the service-specific credential were created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service associated with the service-specific credential.
         */
        var serviceName: kotlin.String? = null
        /**
         * The generated password for the service-specific credential.
         */
        var servicePassword: kotlin.String? = null
        /**
         * The unique identifier for the service-specific credential.
         */
        var serviceSpecificCredentialId: kotlin.String? = null
        /**
         * The generated user name for the service-specific credential. This value is generated by
         * combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
         * jane-at-123456789012, for example. This value cannot be configured by the
         * user.
         */
        var serviceUserName: kotlin.String? = null
        /**
         * The status of the service-specific credential. Active means that the key is
         * valid for API calls, while Inactive means it is not.
         */
        var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The name of the IAM user associated with the service-specific credential.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServiceSpecificCredential) : this() {
            this.createDate = x.createDate
            this.serviceName = x.serviceName
            this.servicePassword = x.servicePassword
            this.serviceSpecificCredentialId = x.serviceSpecificCredentialId
            this.serviceUserName = x.serviceUserName
            this.status = x.status
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredential = ServiceSpecificCredential(this)
    }
}
