// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an X.509 signing certificate.
 * This data type is used as a response element in the UploadSigningCertificate and ListSigningCertificates
 * operations.
 */
class SigningCertificate private constructor(builder: Builder) {
    /**
     * The contents of the signing certificate.
     */
    val certificateBody: kotlin.String? = builder.certificateBody
    /**
     * The ID for the signing certificate.
     */
    val certificateId: kotlin.String? = builder.certificateId
    /**
     * The status of the signing certificate. Active means that the key is valid
     * for API calls, while Inactive means it is not.
     */
    val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The date when the signing certificate was uploaded.
     */
    val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate
    /**
     * The name of the user the signing certificate is associated with.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SigningCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningCertificate(")
        append("certificateBody=$certificateBody,")
        append("certificateId=$certificateId,")
        append("status=$status,")
        append("uploadDate=$uploadDate,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateBody?.hashCode() ?: 0
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningCertificate

        if (certificateBody != other.certificateBody) return false
        if (certificateId != other.certificateId) return false
        if (status != other.status) return false
        if (uploadDate != other.uploadDate) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SigningCertificate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The contents of the signing certificate.
         */
        var certificateBody: kotlin.String? = null
        /**
         * The ID for the signing certificate.
         */
        var certificateId: kotlin.String? = null
        /**
         * The status of the signing certificate. Active means that the key is valid
         * for API calls, while Inactive means it is not.
         */
        var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The date when the signing certificate was uploaded.
         */
        var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the user the signing certificate is associated with.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SigningCertificate) : this() {
            this.certificateBody = x.certificateBody
            this.certificateId = x.certificateId
            this.status = x.status
            this.uploadDate = x.uploadDate
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SigningCertificate = SigningCertificate(this)
    }
}
