// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



class SimulatePrincipalPolicyRequest private constructor(builder: Builder) {
    /**
     * A list of names of API operations to evaluate in the simulation. Each operation is
     * evaluated for each resource. Each operation must include the service identifier, such as
     * iam:CreateUser.
     */
    val actionNames: List<String>? = builder.actionNames
    /**
     * The ARN of the IAM user that you want to specify as the simulated caller of the API
     * operations. If you do not specify a CallerArn, it defaults to the ARN of
     * the user that you specify in PolicySourceArn, if you specified a user. If
     * you include both a PolicySourceArn (for example,
     * arn:aws:iam::123456789012:user/David) and a CallerArn (for
     * example, arn:aws:iam::123456789012:user/Bob), the result is that you
     * simulate calling the API operations as Bob, as if Bob had David's policies.
     * You can specify only the ARN of an IAM user. You cannot specify the ARN of an
     * assumed role, federated user, or a service principal.
     *
     * CallerArn is required if you include a ResourcePolicy and
     * the PolicySourceArn is not the ARN for an IAM user. This is required so
     * that the resource-based policy's Principal element has a value to use in
     * evaluating the policy.
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
     */
    val callerArn: kotlin.String? = builder.callerArn
    /**
     * A list of context keys and corresponding values for the simulation to use. Whenever a
     * context key is evaluated in one of the simulated IAM permissions policies, the
     * corresponding value is supplied.
     */
    val contextEntries: List<ContextEntry>? = builder.contextEntries
    /**
     * Use this parameter only when paginating results and only after
     * you receive a response indicating that the results are truncated. Set it to the value of the
     * Marker element in the response that you received to indicate where the next call
     * should start.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * Use this only when paginating results to indicate the
     * maximum number of items you want in the response. If additional items exist beyond the maximum
     * you specify, the IsTruncated response element is true.
     * If you do not include this parameter, the number of items defaults to 100. Note that
     * IAM might return fewer results, even when there are more results available. In that case, the
     * IsTruncated response element returns true, and Marker
     * contains a value to include in the subsequent call that tells the service where to continue
     * from.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The IAM permissions boundary policy to simulate. The permissions boundary sets the
     * maximum permissions that the entity can have. You can input only one permissions
     * boundary when you pass a policy to this operation. An IAM entity can only have one
     * permissions boundary in effect at a time. For example, if a permissions boundary is
     * attached to an entity and you pass in a different permissions boundary policy using this
     * parameter, then the new permissions boundary policy is used for the simulation. For more
     * information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
     * entities in the IAM User Guide. The policy input is
     * specified as a string containing the complete, valid JSON text of a permissions boundary
     * policy.
     * The maximum length of the policy document that you can pass in this operation,
     * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern
     * used to validate this parameter is a string of characters consisting of the following:
     *
     *
     * Any printable ASCII
     * character ranging from the space character (\u0020) through the end of the ASCII character range
     *
     * The printable characters in the Basic Latin and  Latin-1 Supplement character set
     * (through \u00FF)
     *
     * The special characters tab (\u0009), line feed (\u000A), and
     * carriage return (\u000D)
     */
    val permissionsBoundaryPolicyInputList: List<String>? = builder.permissionsBoundaryPolicyInputList
    /**
     * An optional list of additional policy documents to include in the simulation. Each
     * document is specified as a string containing the complete, valid JSON text of an IAM
     * policy.
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern
     * used to validate this parameter is a string of characters consisting of the following:
     *
     *
     * Any printable ASCII
     * character ranging from the space character (\u0020) through the end of the ASCII character range
     *
     * The printable characters in the Basic Latin and  Latin-1 Supplement character set
     * (through \u00FF)
     *
     * The special characters tab (\u0009), line feed (\u000A), and
     * carriage return (\u000D)
     */
    val policyInputList: List<String>? = builder.policyInputList
    /**
     * The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to
     * include in the simulation. If you specify a user, group, or role, the simulation
     * includes all policies that are associated with that entity. If you specify a user, the
     * simulation also includes all policies that are attached to any groups the user belongs
     * to.
     * The maximum length of the policy document that you can pass in this operation,
     * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
     */
    val policySourceArn: kotlin.String? = builder.policySourceArn
    /**
     * A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
     * not provided, then the value defaults to * (all resources). Each API in the
     * ActionNames parameter is evaluated for each resource in this list. The
     * simulation determines the access result (allowed or denied) of each combination and
     * reports it in the response. You can simulate resources that don't exist in your
     * account.
     * The simulation does not automatically retrieve policies for the specified resources.
     * If you want to include a resource policy in the simulation, then you must include the
     * policy as a string in the ResourcePolicy parameter.
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
     */
    val resourceArns: List<String>? = builder.resourceArns
    /**
     * Specifies the type of simulation to run. Different API operations that support
     * resource-based policies require different combinations of resources. By specifying the
     * type of simulation to run, you enable the policy simulator to enforce the presence of
     * the required resources to ensure reliable simulation results. If your simulation does
     * not match one of the following scenarios, then you can omit this parameter. The
     * following list shows each of the supported scenario values and the resources that you
     * must define to run the simulation.
     * Each of the EC2 scenarios requires that you specify instance, image, and security
     * group resources. If your scenario includes an EBS volume, then you must specify that
     * volume as a resource. If the EC2 scenario includes VPC, then you must supply the network
     * interface resource. If it includes an IP subnet, then you must specify the subnet
     * resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms in the Amazon EC2 User
     * Guide.
     *
     *
     *
     * EC2-Classic-InstanceStore
     *
     * instance, image, security group
     *
     *
     * EC2-Classic-EBS
     *
     * instance, image, security group, volume
     *
     *
     * EC2-VPC-InstanceStore
     *
     * instance, image, security group, network interface
     *
     *
     * EC2-VPC-InstanceStore-Subnet
     *
     * instance, image, security group, network interface, subnet
     *
     *
     * EC2-VPC-EBS
     *
     * instance, image, security group, network interface, volume
     *
     *
     * EC2-VPC-EBS-Subnet
     *
     * instance, image, security group, network interface, subnet, volume
     */
    val resourceHandlingOption: kotlin.String? = builder.resourceHandlingOption
    /**
     * An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
     * identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket
     * or object. If ResourceOwner is specified, it is also used as the account
     * owner of any ResourcePolicy included in the simulation. If the
     * ResourceOwner parameter is not specified, then the owner of the
     * resources and the resource policy defaults to the account of the identity provided in
     * CallerArn. This parameter is required only if you specify a
     * resource-based policy and account that owns the resource is different from the account
     * that owns the simulated calling user CallerArn.
     */
    val resourceOwner: kotlin.String? = builder.resourceOwner
    /**
     * A resource-based policy to include in the simulation provided as a string. Each
     * resource in the simulation is treated as if it had this policy attached. You can include
     * only one resource-based policy in a simulation.
     * The maximum length of the policy document that you can pass in this operation,
     * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern
     * used to validate this parameter is a string of characters consisting of the following:
     *
     *
     * Any printable ASCII
     * character ranging from the space character (\u0020) through the end of the ASCII character range
     *
     * The printable characters in the Basic Latin and  Latin-1 Supplement character set
     * (through \u00FF)
     *
     * The special characters tab (\u0009), line feed (\u000A), and
     * carriage return (\u000D)
     */
    val resourcePolicy: kotlin.String? = builder.resourcePolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimulatePrincipalPolicyRequest(")
        append("actionNames=$actionNames,")
        append("callerArn=$callerArn,")
        append("contextEntries=$contextEntries,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("permissionsBoundaryPolicyInputList=$permissionsBoundaryPolicyInputList,")
        append("policyInputList=$policyInputList,")
        append("policySourceArn=$policySourceArn,")
        append("resourceArns=$resourceArns,")
        append("resourceHandlingOption=$resourceHandlingOption,")
        append("resourceOwner=$resourceOwner,")
        append("resourcePolicy=$resourcePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionNames?.hashCode() ?: 0
        result = 31 * result + (callerArn?.hashCode() ?: 0)
        result = 31 * result + (contextEntries?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (permissionsBoundaryPolicyInputList?.hashCode() ?: 0)
        result = 31 * result + (policyInputList?.hashCode() ?: 0)
        result = 31 * result + (policySourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (resourceHandlingOption?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (resourcePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimulatePrincipalPolicyRequest

        if (actionNames != other.actionNames) return false
        if (callerArn != other.callerArn) return false
        if (contextEntries != other.contextEntries) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (permissionsBoundaryPolicyInputList != other.permissionsBoundaryPolicyInputList) return false
        if (policyInputList != other.policyInputList) return false
        if (policySourceArn != other.policySourceArn) return false
        if (resourceArns != other.resourceArns) return false
        if (resourceHandlingOption != other.resourceHandlingOption) return false
        if (resourceOwner != other.resourceOwner) return false
        if (resourcePolicy != other.resourcePolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of names of API operations to evaluate in the simulation. Each operation is
         * evaluated for each resource. Each operation must include the service identifier, such as
         * iam:CreateUser.
         */
        var actionNames: List<String>? = null
        /**
         * The ARN of the IAM user that you want to specify as the simulated caller of the API
         * operations. If you do not specify a CallerArn, it defaults to the ARN of
         * the user that you specify in PolicySourceArn, if you specified a user. If
         * you include both a PolicySourceArn (for example,
         * arn:aws:iam::123456789012:user/David) and a CallerArn (for
         * example, arn:aws:iam::123456789012:user/Bob), the result is that you
         * simulate calling the API operations as Bob, as if Bob had David's policies.
         * You can specify only the ARN of an IAM user. You cannot specify the ARN of an
         * assumed role, federated user, or a service principal.
         *
         * CallerArn is required if you include a ResourcePolicy and
         * the PolicySourceArn is not the ARN for an IAM user. This is required so
         * that the resource-based policy's Principal element has a value to use in
         * evaluating the policy.
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
         */
        var callerArn: kotlin.String? = null
        /**
         * A list of context keys and corresponding values for the simulation to use. Whenever a
         * context key is evaluated in one of the simulated IAM permissions policies, the
         * corresponding value is supplied.
         */
        var contextEntries: List<ContextEntry>? = null
        /**
         * Use this parameter only when paginating results and only after
         * you receive a response indicating that the results are truncated. Set it to the value of the
         * Marker element in the response that you received to indicate where the next call
         * should start.
         */
        var marker: kotlin.String? = null
        /**
         * Use this only when paginating results to indicate the
         * maximum number of items you want in the response. If additional items exist beyond the maximum
         * you specify, the IsTruncated response element is true.
         * If you do not include this parameter, the number of items defaults to 100. Note that
         * IAM might return fewer results, even when there are more results available. In that case, the
         * IsTruncated response element returns true, and Marker
         * contains a value to include in the subsequent call that tells the service where to continue
         * from.
         */
        var maxItems: kotlin.Int? = null
        /**
         * The IAM permissions boundary policy to simulate. The permissions boundary sets the
         * maximum permissions that the entity can have. You can input only one permissions
         * boundary when you pass a policy to this operation. An IAM entity can only have one
         * permissions boundary in effect at a time. For example, if a permissions boundary is
         * attached to an entity and you pass in a different permissions boundary policy using this
         * parameter, then the new permissions boundary policy is used for the simulation. For more
         * information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
         * entities in the IAM User Guide. The policy input is
         * specified as a string containing the complete, valid JSON text of a permissions boundary
         * policy.
         * The maximum length of the policy document that you can pass in this operation,
         * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern
         * used to validate this parameter is a string of characters consisting of the following:
         *
         *
         * Any printable ASCII
         * character ranging from the space character (\u0020) through the end of the ASCII character range
         *
         * The printable characters in the Basic Latin and  Latin-1 Supplement character set
         * (through \u00FF)
         *
         * The special characters tab (\u0009), line feed (\u000A), and
         * carriage return (\u000D)
         */
        var permissionsBoundaryPolicyInputList: List<String>? = null
        /**
         * An optional list of additional policy documents to include in the simulation. Each
         * document is specified as a string containing the complete, valid JSON text of an IAM
         * policy.
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern
         * used to validate this parameter is a string of characters consisting of the following:
         *
         *
         * Any printable ASCII
         * character ranging from the space character (\u0020) through the end of the ASCII character range
         *
         * The printable characters in the Basic Latin and  Latin-1 Supplement character set
         * (through \u00FF)
         *
         * The special characters tab (\u0009), line feed (\u000A), and
         * carriage return (\u000D)
         */
        var policyInputList: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to
         * include in the simulation. If you specify a user, group, or role, the simulation
         * includes all policies that are associated with that entity. If you specify a user, the
         * simulation also includes all policies that are attached to any groups the user belongs
         * to.
         * The maximum length of the policy document that you can pass in this operation,
         * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
         */
        var policySourceArn: kotlin.String? = null
        /**
         * A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
         * not provided, then the value defaults to * (all resources). Each API in the
         * ActionNames parameter is evaluated for each resource in this list. The
         * simulation determines the access result (allowed or denied) of each combination and
         * reports it in the response. You can simulate resources that don't exist in your
         * account.
         * The simulation does not automatically retrieve policies for the specified resources.
         * If you want to include a resource policy in the simulation, then you must include the
         * policy as a string in the ResourcePolicy parameter.
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
         */
        var resourceArns: List<String>? = null
        /**
         * Specifies the type of simulation to run. Different API operations that support
         * resource-based policies require different combinations of resources. By specifying the
         * type of simulation to run, you enable the policy simulator to enforce the presence of
         * the required resources to ensure reliable simulation results. If your simulation does
         * not match one of the following scenarios, then you can omit this parameter. The
         * following list shows each of the supported scenario values and the resources that you
         * must define to run the simulation.
         * Each of the EC2 scenarios requires that you specify instance, image, and security
         * group resources. If your scenario includes an EBS volume, then you must specify that
         * volume as a resource. If the EC2 scenario includes VPC, then you must supply the network
         * interface resource. If it includes an IP subnet, then you must specify the subnet
         * resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms in the Amazon EC2 User
         * Guide.
         *
         *
         *
         * EC2-Classic-InstanceStore
         *
         * instance, image, security group
         *
         *
         * EC2-Classic-EBS
         *
         * instance, image, security group, volume
         *
         *
         * EC2-VPC-InstanceStore
         *
         * instance, image, security group, network interface
         *
         *
         * EC2-VPC-InstanceStore-Subnet
         *
         * instance, image, security group, network interface, subnet
         *
         *
         * EC2-VPC-EBS
         *
         * instance, image, security group, network interface, volume
         *
         *
         * EC2-VPC-EBS-Subnet
         *
         * instance, image, security group, network interface, subnet, volume
         */
        var resourceHandlingOption: kotlin.String? = null
        /**
         * An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
         * identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket
         * or object. If ResourceOwner is specified, it is also used as the account
         * owner of any ResourcePolicy included in the simulation. If the
         * ResourceOwner parameter is not specified, then the owner of the
         * resources and the resource policy defaults to the account of the identity provided in
         * CallerArn. This parameter is required only if you specify a
         * resource-based policy and account that owns the resource is different from the account
         * that owns the simulated calling user CallerArn.
         */
        var resourceOwner: kotlin.String? = null
        /**
         * A resource-based policy to include in the simulation provided as a string. Each
         * resource in the simulation is treated as if it had this policy attached. You can include
         * only one resource-based policy in a simulation.
         * The maximum length of the policy document that you can pass in this operation,
         * including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas.
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern
         * used to validate this parameter is a string of characters consisting of the following:
         *
         *
         * Any printable ASCII
         * character ranging from the space character (\u0020) through the end of the ASCII character range
         *
         * The printable characters in the Basic Latin and  Latin-1 Supplement character set
         * (through \u00FF)
         *
         * The special characters tab (\u0009), line feed (\u000A), and
         * carriage return (\u000D)
         */
        var resourcePolicy: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest) : this() {
            this.actionNames = x.actionNames
            this.callerArn = x.callerArn
            this.contextEntries = x.contextEntries
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.permissionsBoundaryPolicyInputList = x.permissionsBoundaryPolicyInputList
            this.policyInputList = x.policyInputList
            this.policySourceArn = x.policySourceArn
            this.resourceArns = x.resourceArns
            this.resourceHandlingOption = x.resourceHandlingOption
            this.resourceOwner = x.resourceOwner
            this.resourcePolicy = x.resourcePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest = SimulatePrincipalPolicyRequest(this)
    }
}
