// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an SSH public key, without the key's body or
 * fingerprint.
 * This data type is used as a response element in the ListSSHPublicKeys
 * operation.
 */
class SshPublicKeyMetadata private constructor(builder: Builder) {
    /**
     * The unique identifier for the SSH public key.
     */
    val sshPublicKeyId: kotlin.String? = builder.sshPublicKeyId
    /**
     * The status of the SSH public key. Active means that the key can be used for
     * authentication with an CodeCommit repository. Inactive means that the key cannot be
     * used.
     */
    val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the SSH public key was uploaded.
     */
    val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate
    /**
     * The name of the IAM user associated with the SSH public key.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SshPublicKeyMetadata(")
        append("sshPublicKeyId=$sshPublicKeyId,")
        append("status=$status,")
        append("uploadDate=$uploadDate,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sshPublicKeyId?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SshPublicKeyMetadata

        if (sshPublicKeyId != other.sshPublicKeyId) return false
        if (status != other.status) return false
        if (uploadDate != other.uploadDate) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier for the SSH public key.
         */
        var sshPublicKeyId: kotlin.String? = null
        /**
         * The status of the SSH public key. Active means that the key can be used for
         * authentication with an CodeCommit repository. Inactive means that the key cannot be
         * used.
         */
        var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the SSH public key was uploaded.
         */
        var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the IAM user associated with the SSH public key.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata) : this() {
            this.sshPublicKeyId = x.sshPublicKeyId
            this.status = x.status
            this.uploadDate = x.uploadDate
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = SshPublicKeyMetadata(this)
    }
}
