// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



class UpdateLoginProfileRequest private constructor(builder: Builder) {
    /**
     * The new password for the specified IAM user.
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern
     * used to validate this parameter is a string of characters consisting of the following:
     *
     *
     * Any printable ASCII
     * character ranging from the space character (\u0020) through the end of the ASCII character range
     *
     * The printable characters in the Basic Latin and  Latin-1 Supplement character set
     * (through \u00FF)
     *
     * The special characters tab (\u0009), line feed (\u000A), and
     * carriage return (\u000D)
     *
     *
     * However, the format can be further restricted by the account administrator by setting
     * a password policy on the Amazon Web Services account. For more information, see UpdateAccountPasswordPolicy.
     */
    val password: kotlin.String? = builder.password
    /**
     * Allows this new password to be used only once by requiring the specified IAM user to
     * set a new password on next sign-in.
     */
    val passwordResetRequired: kotlin.Boolean? = builder.passwordResetRequired
    /**
     * The name of the user whose password you want to update.
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern) a string of characters consisting of upper and lowercase alphanumeric
     * characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.UpdateLoginProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLoginProfileRequest(")
        append("password=*** Sensitive Data Redacted ***,")
        append("passwordResetRequired=$passwordResetRequired,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = password?.hashCode() ?: 0
        result = 31 * result + (passwordResetRequired?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLoginProfileRequest

        if (password != other.password) return false
        if (passwordResetRequired != other.passwordResetRequired) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.UpdateLoginProfileRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The new password for the specified IAM user.
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern
         * used to validate this parameter is a string of characters consisting of the following:
         *
         *
         * Any printable ASCII
         * character ranging from the space character (\u0020) through the end of the ASCII character range
         *
         * The printable characters in the Basic Latin and  Latin-1 Supplement character set
         * (through \u00FF)
         *
         * The special characters tab (\u0009), line feed (\u000A), and
         * carriage return (\u000D)
         *
         *
         * However, the format can be further restricted by the account administrator by setting
         * a password policy on the Amazon Web Services account. For more information, see UpdateAccountPasswordPolicy.
         */
        var password: kotlin.String? = null
        /**
         * Allows this new password to be used only once by requiring the specified IAM user to
         * set a new password on next sign-in.
         */
        var passwordResetRequired: kotlin.Boolean? = null
        /**
         * The name of the user whose password you want to update.
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern) a string of characters consisting of upper and lowercase alphanumeric
         * characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.UpdateLoginProfileRequest) : this() {
            this.password = x.password
            this.passwordResetRequired = x.passwordResetRequired
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.UpdateLoginProfileRequest = UpdateLoginProfileRequest(this)
    }
}
