// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM user entity.
 * This data type is used as a response element in the following operations:
 *
 *
 *
 * CreateUser
 *
 *
 *
 * GetUser
 *
 *
 *
 * ListUsers
 */
class User private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
     * and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers in the
     * IAM User Guide.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the user was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the user's password was last used to sign in to an Amazon Web Services website.
     * For a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
     * reports topic in the IAM User Guide. If a password is
     * used more than once in a five-minute span, only the first use is returned in this field. If
     * the field is null (no value), then it indicates that they never signed in with a password.
     * This can be because:
     *
     *
     * The user never had a password.
     *
     * A password exists but has not been used since IAM started tracking this
     * information on October 20, 2014.
     *
     *
     * A null value does not mean that the user never had a password.
     * Also, if the user does not currently have a password but had one in the past, then this
     * field contains the date and time the most recent password was used.
     * This value is returned only in the GetUser and ListUsers operations.
     */
    val passwordLastUsed: aws.smithy.kotlin.runtime.time.Instant? = builder.passwordLastUsed
    /**
     * The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     * The ARN of the policy used to set the permissions boundary for the user.
     */
    val path: kotlin.String? = builder.path
    /**
     * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
     * identities  in the IAM User Guide.
     */
    val permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = builder.permissionsBoundary
    /**
     * A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The stable and unique string identifying the user. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val userId: kotlin.String? = builder.userId
    /**
     * The friendly name identifying the user.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("passwordLastUsed=$passwordLastUsed,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("tags=$tags,")
        append("userId=$userId,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (passwordLastUsed?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (passwordLastUsed != other.passwordLastUsed) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (tags != other.tags) return false
        if (userId != other.userId) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.User = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
         * and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers in the
         * IAM User Guide.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the user was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the user's password was last used to sign in to an Amazon Web Services website.
         * For a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
         * reports topic in the IAM User Guide. If a password is
         * used more than once in a five-minute span, only the first use is returned in this field. If
         * the field is null (no value), then it indicates that they never signed in with a password.
         * This can be because:
         *
         *
         * The user never had a password.
         *
         * A password exists but has not been used since IAM started tracking this
         * information on October 20, 2014.
         *
         *
         * A null value does not mean that the user never had a password.
         * Also, if the user does not currently have a password but had one in the past, then this
         * field contains the date and time the most recent password was used.
         * This value is returned only in the GetUser and ListUsers operations.
         */
        var passwordLastUsed: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         * The ARN of the policy used to set the permissions boundary for the user.
         */
        var path: kotlin.String? = null
        /**
         * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
         * identities  in the IAM User Guide.
         */
        var permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = null
        /**
         * A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
         * IAM User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The stable and unique string identifying the user. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var userId: kotlin.String? = null
        /**
         * The friendly name identifying the user.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.User) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.passwordLastUsed = x.passwordLastUsed
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.tags = x.tags
            this.userId = x.userId
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.User = User(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary] inside the given [block]
         */
        fun permissionsBoundary(block: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.invoke(block)
        }
    }
}
