// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM user, including all the user's policies and all the
 * IAM groups the user is in.
 * This data type is used as a response element in the GetAccountAuthorizationDetails operation.
 */
class UserDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A list of the managed policies attached to the user.
     */
    val attachedManagedPolicies: List<AttachedPolicy>? = builder.attachedManagedPolicies
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     * format, when the user was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A list of IAM groups that the user is in.
     */
    val groupList: List<String>? = builder.groupList
    /**
     * The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
     * IAM User Guide.
     */
    val path: kotlin.String? = builder.path
    /**
     * The ARN of the policy used to set the permissions boundary for the user.
     * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
     * identities  in the IAM User Guide.
     */
    val permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = builder.permissionsBoundary
    /**
     * A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The stable and unique string identifying the user. For more information about IDs, see
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers in the IAM User Guide.
     */
    val userId: kotlin.String? = builder.userId
    /**
     * The friendly name identifying the user.
     */
    val userName: kotlin.String? = builder.userName
    /**
     * A list of the inline policies embedded in the user.
     */
    val userPolicyList: List<PolicyDetail>? = builder.userPolicyList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.UserDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserDetail(")
        append("arn=$arn,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("groupList=$groupList,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("tags=$tags,")
        append("userId=$userId,")
        append("userName=$userName,")
        append("userPolicyList=$userPolicyList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (groupList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userPolicyList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserDetail

        if (arn != other.arn) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (groupList != other.groupList) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (tags != other.tags) return false
        if (userId != other.userId) return false
        if (userName != other.userName) return false
        if (userPolicyList != other.userPolicyList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.UserDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         * For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var arn: kotlin.String? = null
        /**
         * A list of the managed policies attached to the user.
         */
        var attachedManagedPolicies: List<AttachedPolicy>? = null
        /**
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
         * format, when the user was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of IAM groups that the user is in.
         */
        var groupList: List<String>? = null
        /**
         * The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers in the
         * IAM User Guide.
         */
        var path: kotlin.String? = null
        /**
         * The ARN of the policy used to set the permissions boundary for the user.
         * For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
         * identities  in the IAM User Guide.
         */
        var permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = null
        /**
         * A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
         * IAM User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The stable and unique string identifying the user. For more information about IDs, see
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers in the IAM User Guide.
         */
        var userId: kotlin.String? = null
        /**
         * The friendly name identifying the user.
         */
        var userName: kotlin.String? = null
        /**
         * A list of the inline policies embedded in the user.
         */
        var userPolicyList: List<PolicyDetail>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.UserDetail) : this() {
            this.arn = x.arn
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.groupList = x.groupList
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.tags = x.tags
            this.userId = x.userId
            this.userName = x.userName
            this.userPolicyList = x.userPolicyList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.UserDetail = UserDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary] inside the given [block]
         */
        fun permissionsBoundary(block: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.invoke(block)
        }
    }
}
