// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a virtual MFA device.
 */
class VirtualMfaDevice private constructor(builder: Builder) {
    /**
     * The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548. The Base32StringSeed is base64-encoded.
     */
    val base32StringSeed: kotlin.ByteArray? = builder.base32StringSeed
    /**
     * The date and time on which the virtual MFA device was enabled.
     */
    val enableDate: aws.smithy.kotlin.runtime.time.Instant? = builder.enableDate
    /**
     * A QR code PNG image that encodes
     * otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String
     * where $virtualMFADeviceName is one of the create call arguments.
     * AccountName is the user name if set (otherwise, the account ID otherwise),
     * and Base32String is the seed in base32 format. The Base32String
     * value is base64-encoded.
     */
    val qrCodePng: kotlin.ByteArray? = builder.qrCodePng
    /**
     * The serial number associated with VirtualMFADevice.
     */
    val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
     * IAM User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The IAM user associated with this virtual MFA device.
     */
    val user: aws.sdk.kotlin.services.iam.model.User? = builder.user

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.VirtualMfaDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualMfaDevice(")
        append("base32StringSeed=*** Sensitive Data Redacted ***,")
        append("enableDate=$enableDate,")
        append("qrCodePng=*** Sensitive Data Redacted ***,")
        append("serialNumber=$serialNumber,")
        append("tags=$tags,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = base32StringSeed?.contentHashCode() ?: 0
        result = 31 * result + (enableDate?.hashCode() ?: 0)
        result = 31 * result + (qrCodePng?.contentHashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualMfaDevice

        if (base32StringSeed != null) {
            if (other.base32StringSeed == null) return false
            if (!base32StringSeed.contentEquals(other.base32StringSeed)) return false
        } else if (other.base32StringSeed != null) return false
        if (enableDate != other.enableDate) return false
        if (qrCodePng != null) {
            if (other.qrCodePng == null) return false
            if (!qrCodePng.contentEquals(other.qrCodePng)) return false
        } else if (other.qrCodePng != null) return false
        if (serialNumber != other.serialNumber) return false
        if (tags != other.tags) return false
        if (user != other.user) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.VirtualMfaDevice = Builder(this).apply(block).build()

    class Builder {
        /**
         * The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548. The Base32StringSeed is base64-encoded.
         */
        var base32StringSeed: kotlin.ByteArray? = null
        /**
         * The date and time on which the virtual MFA device was enabled.
         */
        var enableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A QR code PNG image that encodes
         * otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String
         * where $virtualMFADeviceName is one of the create call arguments.
         * AccountName is the user name if set (otherwise, the account ID otherwise),
         * and Base32String is the seed in base32 format. The Base32String
         * value is base64-encoded.
         */
        var qrCodePng: kotlin.ByteArray? = null
        /**
         * The serial number associated with VirtualMFADevice.
         */
        var serialNumber: kotlin.String? = null
        /**
         * A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources in the
         * IAM User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The IAM user associated with this virtual MFA device.
         */
        var user: aws.sdk.kotlin.services.iam.model.User? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.VirtualMfaDevice) : this() {
            this.base32StringSeed = x.base32StringSeed
            this.enableDate = x.enableDate
            this.qrCodePng = x.qrCodePng
            this.serialNumber = x.serialNumber
            this.tags = x.tags
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.VirtualMfaDevice = VirtualMfaDevice(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.User] inside the given [block]
         */
        fun user(block: aws.sdk.kotlin.services.iam.model.User.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.iam.model.User.invoke(block)
        }
    }
}
