// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.iam.model.AddRoleToInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AddRoleToInstanceProfileOperationDeserializer: HttpDeserialize<AddRoleToInstanceProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddRoleToInstanceProfileResponse {
        if (!response.status.isSuccess()) {
            throwAddRoleToInstanceProfileError(context, response)
        }
        val builder = AddRoleToInstanceProfileResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAddRoleToInstanceProfileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EntityAlreadyExists" -> EntityAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceeded" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnmodifiableEntity" -> UnmodifiableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
