// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.iam.model.AccessAdvisorUsageGranularityType
import aws.sdk.kotlin.services.iam.model.ErrorDetails
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.JobStatusType
import aws.sdk.kotlin.services.iam.model.ServiceLastAccessed
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetServiceLastAccessedDetailsOperationDeserializer: HttpDeserialize<GetServiceLastAccessedDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetServiceLastAccessedDetailsResponse {
        if (!response.status.isSuccess()) {
            throwGetServiceLastAccessedDetailsError(context, response)
        }
        val builder = GetServiceLastAccessedDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServiceLastAccessedDetailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetServiceLastAccessedDetailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceLastAccessedDetailsOperationBody(builder: GetServiceLastAccessedDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetServiceLastAccessedDetailsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetServiceLastAccessedDetailsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetServiceLastAccessedDetails response")
    }
    // end unwrap response wrapper

    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Error"))
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val JOBCOMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("JobCompletionDate"))
    val JOBCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("JobCreationDate"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("JobStatus"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("JobType"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val SERVICESLASTACCESSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ServicesLastAccessed"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetServiceLastAccessedDetailsResult"))
        field(ERROR_DESCRIPTOR)
        field(ISTRUNCATED_DESCRIPTOR)
        field(JOBCOMPLETIONDATE_DESCRIPTOR)
        field(JOBCREATIONDATE_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(SERVICESLASTACCESSED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorDetailsDocument(deserializer)
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                JOBCOMPLETIONDATE_DESCRIPTOR.index -> builder.jobCompletionDate = deserializeString().let { Instant.fromIso8601(it) }
                JOBCREATIONDATE_DESCRIPTOR.index -> builder.jobCreationDate = deserializeString().let { Instant.fromIso8601(it) }
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatusType.fromValue(it) }
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { AccessAdvisorUsageGranularityType.fromValue(it) }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                SERVICESLASTACCESSED_DESCRIPTOR.index -> builder.servicesLastAccessed =
                    deserializer.deserializeList(SERVICESLASTACCESSED_DESCRIPTOR) {
                        val col0 = mutableListOf<ServiceLastAccessed>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceLastAccessedDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
