// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.UpdateSshPublicKeyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateSSHPublicKeyOperationDeserializer: HttpDeserialize<UpdateSshPublicKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSshPublicKeyResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSshPublicKeyError(context, response)
        }
        val builder = UpdateSshPublicKeyResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateSshPublicKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
