// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.endpoints

import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.sdk.kotlin.services.iam.endpoints.internal.partition
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.http.endpoints.functions.parseUrl
import aws.smithy.kotlin.runtime.util.Attributes

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null
            ) {
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null
                    ) {
                        if (
                            params.useFips == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
                        }
                        return Endpoint(
                            Url.parse(params.endpoint),
                        )
                    }
                }
                if (
                    partitionResult?.name == "aws"
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.api.aws"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.${params.region}.api.aws"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://iam.amazonaws.com"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    partitionResult?.name == "aws-cn"
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.api.amazonwebservices.com.cn"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "cn-north-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.amazonaws.com.cn"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "cn-north-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.${params.region}.api.amazonwebservices.com.cn"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "cn-north-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://iam.cn-north-1.amazonaws.com.cn"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "cn-north-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    partitionResult?.name == "aws-us-gov"
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.api.aws"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-gov-west-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.us-gov.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-gov-west-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.${params.region}.api.aws"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-gov-west-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://iam.us-gov.amazonaws.com"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-gov-west-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    partitionResult?.name == "aws-iso"
                ) {
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.c2s.ic.gov"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-iso-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    return Endpoint(
                        Url.parse("https://iam.us-iso-east-1.c2s.ic.gov"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-iso-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    partitionResult?.name == "aws-iso-b"
                ) {
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.${params.region}.sc2s.sgov.gov"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-isob-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    return Endpoint(
                        Url.parse("https://iam.us-isob-east-1.sc2s.sgov.gov"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-isob-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    params.useFips == true &&
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS &&
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://iam-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                }
                if (
                    params.useFips == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS
                    ) {
                        if (
                            params.region == "iam"
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.region == "aws-global"
                        ) {
                            return Endpoint(
                                Url.parse("https://iam-fips.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-east-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.region == "iam-govcloud"
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.us-gov.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-gov-west-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            params.region == "aws-us-gov-global"
                        ) {
                            return Endpoint(
                                Url.parse("https://iam.us-gov.amazonaws.com"),
                                attributes = Attributes().apply {
                                    set(
                                        AuthSchemesAttributeKey,
                                        listOf(
                                            AuthScheme.SigV4(
                                                signingName = "iam",
                                                disableDoubleEncoding = false,
                                                signingRegion = "us-gov-west-1",
                                            ),
                                        ),
                                    )
                                },
                            )
                        }
                        return Endpoint(
                            Url.parse("https://iam-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                }
                if (
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://iam.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                }
                if (
                    params.region == "aws-global"
                ) {
                    return Endpoint(
                        Url.parse("https://iam.amazonaws.com"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    params.region == "aws-cn-global"
                ) {
                    return Endpoint(
                        Url.parse("https://iam.cn-north-1.amazonaws.com.cn"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "cn-north-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    params.region == "aws-us-gov-global"
                ) {
                    return Endpoint(
                        Url.parse("https://iam.us-gov.amazonaws.com"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-gov-west-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    params.region == "aws-iso-global"
                ) {
                    return Endpoint(
                        Url.parse("https://iam.us-iso-east-1.c2s.ic.gov"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-iso-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                if (
                    params.region == "aws-iso-b-global"
                ) {
                    return Endpoint(
                        Url.parse("https://iam.us-isob-east-1.sc2s.sgov.gov"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "iam",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-isob-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                return Endpoint(
                    Url.parse("https://iam.${params.region}.${partitionResult?.dnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
