// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the last time an Amazon Web Services access key was used since IAM began tracking this information on April 22, 2015.
 *
 * This data type is used as a response element in the GetAccessKeyLastUsed operation.
 */
public class AccessKeyLastUsed private constructor(builder: Builder) {
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the access key was most recently used. This field is null in the following situations:
     * + The user does not have an access key.
     * + An access key exists but has not been used since IAM began tracking this information.
     * + There is no sign-in data associated with the user.
     */
    public val lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUsedDate
    /**
     * The Amazon Web Services Region where this access key was most recently used. The value for this field is "N/A" in the following situations:
     * + The user does not have an access key.
     * + An access key exists but has not been used since IAM began tracking this information.
     * + There is no sign-in data associated with the user.
     *
     * For more information about Amazon Web Services Regions, see [Regions and endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html) in the Amazon Web Services General Reference.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The name of the Amazon Web Services service with which this access key was most recently used. The value of this field is "N/A" in the following situations:
     * + The user does not have an access key.
     * + An access key exists but has not been used since IAM started tracking this information.
     * + There is no sign-in data associated with the user.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.AccessKeyLastUsed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessKeyLastUsed(")
        append("lastUsedDate=$lastUsedDate,")
        append("region=$region,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUsedDate?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessKeyLastUsed

        if (lastUsedDate != other.lastUsedDate) return false
        if (region != other.region) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.AccessKeyLastUsed = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the access key was most recently used. This field is null in the following situations:
         * + The user does not have an access key.
         * + An access key exists but has not been used since IAM began tracking this information.
         * + There is no sign-in data associated with the user.
         */
        public var lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region where this access key was most recently used. The value for this field is "N/A" in the following situations:
         * + The user does not have an access key.
         * + An access key exists but has not been used since IAM began tracking this information.
         * + There is no sign-in data associated with the user.
         *
         * For more information about Amazon Web Services Regions, see [Regions and endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html) in the Amazon Web Services General Reference.
         */
        public var region: kotlin.String? = null
        /**
         * The name of the Amazon Web Services service with which this access key was most recently used. The value of this field is "N/A" in the following situations:
         * + The user does not have an access key.
         * + An access key exists but has not been used since IAM started tracking this information.
         * + There is no sign-in data associated with the user.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.AccessKeyLastUsed) : this() {
            this.lastUsedDate = x.lastUsedDate
            this.region = x.region
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.AccessKeyLastUsed = AccessKeyLastUsed(this)
    }
}
