// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about an attached permissions boundary.
 *
 * An attached permissions boundary is a managed policy that has been attached to a user or role to set the permissions boundary.
 *
 * For more information about permissions boundaries, see [Permissions boundaries for IAM identities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
 */
public class AttachedPermissionsBoundary private constructor(builder: Builder) {
    /**
     * The ARN of the policy used to set the permissions boundary for the user or role.
     */
    public val permissionsBoundaryArn: kotlin.String? = builder.permissionsBoundaryArn
    /**
     * The permissions boundary usage type that indicates what type of IAM resource is used as the permissions boundary for an entity. This data type can only have a value of `Policy`.
     */
    public val permissionsBoundaryType: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryAttachmentType? = builder.permissionsBoundaryType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachedPermissionsBoundary(")
        append("permissionsBoundaryArn=$permissionsBoundaryArn,")
        append("permissionsBoundaryType=$permissionsBoundaryType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = permissionsBoundaryArn?.hashCode() ?: 0
        result = 31 * result + (permissionsBoundaryType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachedPermissionsBoundary

        if (permissionsBoundaryArn != other.permissionsBoundaryArn) return false
        if (permissionsBoundaryType != other.permissionsBoundaryType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the policy used to set the permissions boundary for the user or role.
         */
        public var permissionsBoundaryArn: kotlin.String? = null
        /**
         * The permissions boundary usage type that indicates what type of IAM resource is used as the permissions boundary for an entity. This data type can only have a value of `Policy`.
         */
        public var permissionsBoundaryType: aws.sdk.kotlin.services.iam.model.PermissionsBoundaryAttachmentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary) : this() {
            this.permissionsBoundaryArn = x.permissionsBoundaryArn
            this.permissionsBoundaryType = x.permissionsBoundaryType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary = AttachedPermissionsBoundary(this)
    }
}
