// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about an attached policy.
 *
 * An attached policy is a managed policy that has been attached to a user, group, or role. This data type is used as a response element in the ListAttachedGroupPolicies, ListAttachedRolePolicies, ListAttachedUserPolicies, and GetAccountAuthorizationDetails operations.
 *
 * For more information about managed policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public class AttachedPolicy private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     *
     * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The friendly name of the attached policy.
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.AttachedPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachedPolicy(")
        append("policyArn=$policyArn,")
        append("policyName=$policyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyArn?.hashCode() ?: 0
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachedPolicy

        if (policyArn != other.policyArn) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.AttachedPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         *
         * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The friendly name of the attached policy.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.AttachedPolicy) : this() {
            this.policyArn = x.policyArn
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.AttachedPolicy = AttachedPolicy(this)
    }
}
