// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class CreateLoginProfileRequest private constructor(builder: Builder) {
    /**
     * The new password for the user.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (`\u0020`) through the end of the ASCII character range (`\u00FF`). You can also include the tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) characters. Any of these characters are valid in a password. However, many tools, such as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Specifies whether the user is required to set a new password on next sign-in.
     */
    public val passwordResetRequired: kotlin.Boolean = builder.passwordResetRequired
    /**
     * The name of the IAM user to create a password for. The user must already exist.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.CreateLoginProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLoginProfileRequest(")
        append("password=*** Sensitive Data Redacted ***,")
        append("passwordResetRequired=$passwordResetRequired,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = password?.hashCode() ?: 0
        result = 31 * result + (passwordResetRequired.hashCode())
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLoginProfileRequest

        if (password != other.password) return false
        if (passwordResetRequired != other.passwordResetRequired) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.CreateLoginProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The new password for the user.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (`\u0020`) through the end of the ASCII character range (`\u00FF`). You can also include the tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) characters. Any of these characters are valid in a password. However, many tools, such as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies whether the user is required to set a new password on next sign-in.
         */
        public var passwordResetRequired: kotlin.Boolean = false
        /**
         * The name of the IAM user to create a password for. The user must already exist.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.CreateLoginProfileRequest) : this() {
            this.password = x.password
            this.passwordResetRequired = x.passwordResetRequired
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.CreateLoginProfileRequest = CreateLoginProfileRequest(this)
    }
}
