// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful CreateOpenIDConnectProvider request.
 */
public class CreateOpenIdConnectProviderResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see OpenIDConnectProviderListEntry.
     */
    public val openIdConnectProviderArn: kotlin.String? = builder.openIdConnectProviderArn
    /**
     * A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOpenIdConnectProviderResponse(")
        append("openIdConnectProviderArn=$openIdConnectProviderArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = openIdConnectProviderArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOpenIdConnectProviderResponse

        if (openIdConnectProviderArn != other.openIdConnectProviderArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see OpenIDConnectProviderListEntry.
         */
        public var openIdConnectProviderArn: kotlin.String? = null
        /**
         * A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderResponse) : this() {
            this.openIdConnectProviderArn = x.openIdConnectProviderArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderResponse = CreateOpenIdConnectProviderResponse(this)
    }
}
