// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class CreatePolicyRequest private constructor(builder: Builder) {
    /**
     * A friendly description of the policy.
     *
     * Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     *
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The path for the policy.
     *
     * For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     *
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
     *
     * You cannot use an asterisk (*) in the path name.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The JSON policy document that you want to use as the content for the new policy.
     *
     * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     *
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see [IAM and STS character quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
     *
     * To learn more about JSON policy grammar, see [Grammar of the IAM JSON policy language](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html) in the *IAM User Guide*.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * The friendly name of the policy.
     *
     * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * A list of tags that you want to attach to the new IAM customer managed policy. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.CreatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePolicyRequest(")
        append("description=$description,")
        append("path=$path,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePolicyRequest

        if (description != other.description) return false
        if (path != other.path) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.CreatePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A friendly description of the policy.
         *
         * Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         *
         * The policy description is immutable. After a value is assigned, it cannot be changed.
         */
        public var description: kotlin.String? = null
        /**
         * The path for the policy.
         *
         * For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         *
         * This parameter is optional. If it is not included, it defaults to a slash (/).
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
         *
         * You cannot use an asterisk (*) in the path name.
         */
        public var path: kotlin.String? = null
        /**
         * The JSON policy document that you want to use as the content for the new policy.
         *
         * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         *
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see [IAM and STS character quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
         *
         * To learn more about JSON policy grammar, see [Grammar of the IAM JSON policy language](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html) in the *IAM User Guide*.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The friendly name of the policy.
         *
         * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".
         */
        public var policyName: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the new IAM customer managed policy. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         *
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.CreatePolicyRequest) : this() {
            this.description = x.description
            this.path = x.path
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.CreatePolicyRequest = CreatePolicyRequest(this)
    }
}
