// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class CreatePolicyVersionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.
     *
     * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The JSON policy document that you want to use as the content for this new version of the policy.
     *
     * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     *
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see [IAM and STS character quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * Specifies whether to set this version as the policy's default version.
     *
     * When this parameter is `true`, the new policy version becomes the operative version. That is, it becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached to.
     *
     * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     */
    public val setAsDefault: kotlin.Boolean = builder.setAsDefault

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.CreatePolicyVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePolicyVersionRequest(")
        append("policyArn=$policyArn,")
        append("policyDocument=$policyDocument,")
        append("setAsDefault=$setAsDefault)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyArn?.hashCode() ?: 0
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (setAsDefault.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePolicyVersionRequest

        if (policyArn != other.policyArn) return false
        if (policyDocument != other.policyDocument) return false
        if (setAsDefault != other.setAsDefault) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.CreatePolicyVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new version.
         *
         * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The JSON policy document that you want to use as the content for this new version of the policy.
         *
         * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         *
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see [IAM and STS character quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var policyDocument: kotlin.String? = null
        /**
         * Specifies whether to set this version as the policy's default version.
         *
         * When this parameter is `true`, the new policy version becomes the operative version. That is, it becomes the version that is in effect for the IAM users, groups, and roles that the policy is attached to.
         *
         * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
         */
        public var setAsDefault: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.CreatePolicyVersionRequest) : this() {
            this.policyArn = x.policyArn
            this.policyDocument = x.policyDocument
            this.setAsDefault = x.setAsDefault
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.CreatePolicyVersionRequest = CreatePolicyVersionRequest(this)
    }
}
