// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class EnableMfaDeviceRequest private constructor(builder: Builder) {
    /**
     * An authentication code emitted by the device.
     *
     * The format for this parameter is a string of six digits.
     *
     * Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can [resync the device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
     */
    public val authenticationCode1: kotlin.String? = builder.authenticationCode1
    /**
     * A subsequent authentication code emitted by the device.
     *
     * The format for this parameter is a string of six digits.
     *
     * Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can [resync the device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
     */
    public val authenticationCode2: kotlin.String? = builder.authenticationCode2
    /**
     * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-
     */
    public val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The name of the IAM user for whom you want to enable the MFA device.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.EnableMfaDeviceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableMfaDeviceRequest(")
        append("authenticationCode1=$authenticationCode1,")
        append("authenticationCode2=$authenticationCode2,")
        append("serialNumber=$serialNumber,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationCode1?.hashCode() ?: 0
        result = 31 * result + (authenticationCode2?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableMfaDeviceRequest

        if (authenticationCode1 != other.authenticationCode1) return false
        if (authenticationCode2 != other.authenticationCode2) return false
        if (serialNumber != other.serialNumber) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.EnableMfaDeviceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An authentication code emitted by the device.
         *
         * The format for this parameter is a string of six digits.
         *
         * Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can [resync the device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
         */
        public var authenticationCode1: kotlin.String? = null
        /**
         * A subsequent authentication code emitted by the device.
         *
         * The format for this parameter is a string of six digits.
         *
         * Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can [resync the device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
         */
        public var authenticationCode2: kotlin.String? = null
        /**
         * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The name of the IAM user for whom you want to enable the MFA device.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.EnableMfaDeviceRequest) : this() {
            this.authenticationCode1 = x.authenticationCode1
            this.authenticationCode2 = x.authenticationCode2
            this.serialNumber = x.serialNumber
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.EnableMfaDeviceRequest = EnableMfaDeviceRequest(this)
    }
}
