// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetOrganizationsAccessReportResponse private constructor(builder: Builder) {
    /**
     * An object that contains details about the most recent attempt to access the service.
     */
    public val accessDetails: List<AccessDetail>? = builder.accessDetails
    /**
     * Contains information about the reason that the operation failed.
     *
     * This data type is used as a response element in the GetOrganizationsAccessReport, GetServiceLastAccessedDetails, and GetServiceLastAccessedDetailsWithEntities operations.
     */
    public val errorDetails: aws.sdk.kotlin.services.iam.model.ErrorDetails? = builder.errorDetails
    /**
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
     */
    public val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the generated report job was completed or failed.
     *
     * This field is null if the job is still in progress, as indicated by a job status value of `IN_PROGRESS`.
     */
    public val jobCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.jobCompletionDate
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the report job was created.
     */
    public val jobCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.jobCreationDate
    /**
     * The status of the job.
     */
    public val jobStatus: aws.sdk.kotlin.services.iam.model.JobStatusType? = builder.jobStatus
    /**
     * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The number of services that the applicable SCPs allow account principals to access.
     */
    public val numberOfServicesAccessible: kotlin.Int? = builder.numberOfServicesAccessible
    /**
     * The number of services that account principals are allowed but did not attempt to access.
     */
    public val numberOfServicesNotAccessed: kotlin.Int? = builder.numberOfServicesNotAccessed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetOrganizationsAccessReportResponse(")
        append("accessDetails=$accessDetails,")
        append("errorDetails=$errorDetails,")
        append("isTruncated=$isTruncated,")
        append("jobCompletionDate=$jobCompletionDate,")
        append("jobCreationDate=$jobCreationDate,")
        append("jobStatus=$jobStatus,")
        append("marker=$marker,")
        append("numberOfServicesAccessible=$numberOfServicesAccessible,")
        append("numberOfServicesNotAccessed=$numberOfServicesNotAccessed)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessDetails?.hashCode() ?: 0
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (jobCompletionDate?.hashCode() ?: 0)
        result = 31 * result + (jobCreationDate?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (numberOfServicesAccessible ?: 0)
        result = 31 * result + (numberOfServicesNotAccessed ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetOrganizationsAccessReportResponse

        if (accessDetails != other.accessDetails) return false
        if (errorDetails != other.errorDetails) return false
        if (isTruncated != other.isTruncated) return false
        if (jobCompletionDate != other.jobCompletionDate) return false
        if (jobCreationDate != other.jobCreationDate) return false
        if (jobStatus != other.jobStatus) return false
        if (marker != other.marker) return false
        if (numberOfServicesAccessible != other.numberOfServicesAccessible) return false
        if (numberOfServicesNotAccessed != other.numberOfServicesNotAccessed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains details about the most recent attempt to access the service.
         */
        public var accessDetails: List<AccessDetail>? = null
        /**
         * Contains information about the reason that the operation failed.
         *
         * This data type is used as a response element in the GetOrganizationsAccessReport, GetServiceLastAccessedDetails, and GetServiceLastAccessedDetailsWithEntities operations.
         */
        public var errorDetails: aws.sdk.kotlin.services.iam.model.ErrorDetails? = null
        /**
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
         */
        public var isTruncated: kotlin.Boolean = false
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the generated report job was completed or failed.
         *
         * This field is null if the job is still in progress, as indicated by a job status value of `IN_PROGRESS`.
         */
        public var jobCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the report job was created.
         */
        public var jobCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the job.
         */
        public var jobStatus: aws.sdk.kotlin.services.iam.model.JobStatusType? = null
        /**
         * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
         */
        public var marker: kotlin.String? = null
        /**
         * The number of services that the applicable SCPs allow account principals to access.
         */
        public var numberOfServicesAccessible: kotlin.Int? = null
        /**
         * The number of services that account principals are allowed but did not attempt to access.
         */
        public var numberOfServicesNotAccessed: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportResponse) : this() {
            this.accessDetails = x.accessDetails
            this.errorDetails = x.errorDetails
            this.isTruncated = x.isTruncated
            this.jobCompletionDate = x.jobCompletionDate
            this.jobCreationDate = x.jobCreationDate
            this.jobStatus = x.jobStatus
            this.marker = x.marker
            this.numberOfServicesAccessible = x.numberOfServicesAccessible
            this.numberOfServicesNotAccessed = x.numberOfServicesNotAccessed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportResponse = GetOrganizationsAccessReportResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.ErrorDetails] inside the given [block]
         */
        public fun errorDetails(block: aws.sdk.kotlin.services.iam.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.errorDetails = aws.sdk.kotlin.services.iam.model.ErrorDetails.invoke(block)
        }
    }
}
