// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM group entity.
 *
 * This data type is used as a response element in the following operations:
 * + CreateGroup
 * + GetGroup
 * + ListGroups
 */
public class Group private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) specifying the group. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the group was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The stable and unique string identifying the group. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The friendly name that identifies the group.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The path to the group. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.Group = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Group(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("path=$path)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Group

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.Group = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) specifying the group. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the group was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stable and unique string identifying the group. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var groupId: kotlin.String? = null
        /**
         * The friendly name that identifies the group.
         */
        public var groupName: kotlin.String? = null
        /**
         * The path to the group. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.Group) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.Group = Group(this)
    }
}
