// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains details about the permissions policies that are attached to the specified identity (user, group, or role).
 *
 * This data type is used as a response element in the ListPoliciesGrantingServiceAccess operation.
 */
public class ListPoliciesGrantingServiceAccessEntry private constructor(builder: Builder) {
    /**
     * The `PoliciesGrantingServiceAccess` object that contains details about the policy.
     */
    public val policies: List<PolicyGrantingServiceAccess>? = builder.policies
    /**
     * The namespace of the service that was accessed.
     *
     * To learn the service namespace of a service, see [Actions, resources, and condition keys for Amazon Web Services services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) in the *Service Authorization Reference*. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, `(service prefix: a4b)`. For more information about service namespaces, see [Amazon Web Services service namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) in the *Amazon Web Services General Reference*.
     */
    public val serviceNamespace: kotlin.String? = builder.serviceNamespace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPoliciesGrantingServiceAccessEntry(")
        append("policies=$policies,")
        append("serviceNamespace=$serviceNamespace)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policies?.hashCode() ?: 0
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPoliciesGrantingServiceAccessEntry

        if (policies != other.policies) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `PoliciesGrantingServiceAccess` object that contains details about the policy.
         */
        public var policies: List<PolicyGrantingServiceAccess>? = null
        /**
         * The namespace of the service that was accessed.
         *
         * To learn the service namespace of a service, see [Actions, resources, and condition keys for Amazon Web Services services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) in the *Service Authorization Reference*. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, `(service prefix: a4b)`. For more information about service namespaces, see [Amazon Web Services service namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) in the *Amazon Web Services General Reference*.
         */
        public var serviceNamespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessEntry) : this() {
            this.policies = x.policies
            this.serviceNamespace = x.serviceNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessEntry = ListPoliciesGrantingServiceAccessEntry(this)
    }
}
