// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a version of a managed policy.
 *
 * This data type is used as a response element in the CreatePolicyVersion, GetPolicyVersion, ListPolicyVersions, and GetAccountAuthorizationDetails operations.
 *
 * For more information about managed policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public class PolicyVersion private constructor(builder: Builder) {
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy version was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The policy document.
     *
     * The policy document is returned in the response to the GetPolicyVersion and GetAccountAuthorizationDetails operations. It is not returned in the response to the CreatePolicyVersion or ListPolicyVersions operations.
     *
     * The policy document returned in this structure is URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     */
    public val document: kotlin.String? = builder.document
    /**
     * Specifies whether the policy version is set as the policy's default version.
     */
    public val isDefaultVersion: kotlin.Boolean = builder.isDefaultVersion
    /**
     * The identifier for the policy version.
     *
     * Policy version identifiers always begin with `v` (always lowercase). When a policy is created, the first policy version is `v1`.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyVersion(")
        append("createDate=$createDate,")
        append("document=$document,")
        append("isDefaultVersion=$isDefaultVersion,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createDate?.hashCode() ?: 0
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (isDefaultVersion.hashCode())
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyVersion

        if (createDate != other.createDate) return false
        if (document != other.document) return false
        if (isDefaultVersion != other.isDefaultVersion) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyVersion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy version was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The policy document.
         *
         * The policy document is returned in the response to the GetPolicyVersion and GetAccountAuthorizationDetails operations. It is not returned in the response to the CreatePolicyVersion or ListPolicyVersions operations.
         *
         * The policy document returned in this structure is URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
         */
        public var document: kotlin.String? = null
        /**
         * Specifies whether the policy version is set as the policy's default version.
         */
        public var isDefaultVersion: kotlin.Boolean = false
        /**
         * The identifier for the policy version.
         *
         * Policy version identifiers always begin with `v` (always lowercase). When a policy is created, the first policy version is `v1`.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyVersion) : this() {
            this.createDate = x.createDate
            this.document = x.document
            this.isDefaultVersion = x.isDefaultVersion
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyVersion = PolicyVersion(this)
    }
}
