// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period) in the *IAM User Guide*.
 *
 * This data type is returned as a response element in the GetRole and GetAccountAuthorizationDetails operations.
 */
public class RoleLastUsed private constructor(builder: Builder) {
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601) that the role was last used.
     *
     * This field is null if the role has not been used within the IAM tracking period. For more information about the tracking period, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period) in the *IAM User Guide*.
     */
    public val lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUsedDate
    /**
     * The name of the Amazon Web Services Region in which the role was last used.
     */
    public val region: kotlin.String? = builder.region

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.RoleLastUsed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleLastUsed(")
        append("lastUsedDate=$lastUsedDate,")
        append("region=$region)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUsedDate?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleLastUsed

        if (lastUsedDate != other.lastUsedDate) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.RoleLastUsed = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601) that the role was last used.
         *
         * This field is null if the role has not been used within the IAM tracking period. For more information about the tracking period, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period) in the *IAM User Guide*.
         */
        public var lastUsedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Web Services Region in which the role was last used.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.RoleLastUsed) : this() {
            this.lastUsedDate = x.lastUsedDate
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.RoleLastUsed = RoleLastUsed(this)
    }
}
