// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a server certificate.
 *
 *  This data type is used as a response element in the GetServerCertificate operation.
 */
public class ServerCertificate private constructor(builder: Builder) {
    /**
     * The contents of the public key certificate.
     */
    public val certificateBody: kotlin.String? = builder.certificateBody
    /**
     * The contents of the public key certificate chain.
     */
    public val certificateChain: kotlin.String? = builder.certificateChain
    /**
     * The meta information of the server certificate, such as its name, path, ID, and ARN.
     */
    public val serverCertificateMetadata: aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata? = builder.serverCertificateMetadata
    /**
     * A list of tags that are attached to the server certificate. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServerCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificate(")
        append("certificateBody=$certificateBody,")
        append("certificateChain=$certificateChain,")
        append("serverCertificateMetadata=$serverCertificateMetadata,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateBody?.hashCode() ?: 0
        result = 31 * result + (certificateChain?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateMetadata?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificate

        if (certificateBody != other.certificateBody) return false
        if (certificateChain != other.certificateChain) return false
        if (serverCertificateMetadata != other.serverCertificateMetadata) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServerCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The contents of the public key certificate.
         */
        public var certificateBody: kotlin.String? = null
        /**
         * The contents of the public key certificate chain.
         */
        public var certificateChain: kotlin.String? = null
        /**
         * The meta information of the server certificate, such as its name, path, ID, and ARN.
         */
        public var serverCertificateMetadata: aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata? = null
        /**
         * A list of tags that are attached to the server certificate. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServerCertificate) : this() {
            this.certificateBody = x.certificateBody
            this.certificateChain = x.certificateChain
            this.serverCertificateMetadata = x.serverCertificateMetadata
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServerCertificate = ServerCertificate(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata] inside the given [block]
         */
        public fun serverCertificateMetadata(block: aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata.Builder.() -> kotlin.Unit) {
            this.serverCertificateMetadata = aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata.invoke(block)
        }
    }
}
