// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the most recent attempt to access the service.
 *
 * This data type is used as a response element in the GetServiceLastAccessedDetails operation.
 */
public class ServiceLastAccessed private constructor(builder: Builder) {
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when an authenticated entity most recently attempted to access the service. Amazon Web Services does not report unauthenticated requests.
     *
     * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val lastAuthenticated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAuthenticated
    /**
     * The ARN of the authenticated entity (user or role) that last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
     *
     * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val lastAuthenticatedEntity: kotlin.String? = builder.lastAuthenticatedEntity
    /**
     * The Region from which the authenticated entity (user or role) last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
     *
     * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val lastAuthenticatedRegion: kotlin.String? = builder.lastAuthenticatedRegion
    /**
     * The name of the service in which access was attempted.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The namespace of the service in which access was attempted.
     *
     * To learn the service namespace of a service, see [Actions, resources, and condition keys for Amazon Web Services services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) in the *Service Authorization Reference*. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, `(service prefix: a4b)`. For more information about service namespaces, see [Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) in the *Amazon Web Services General Reference*.
     */
    public val serviceNamespace: kotlin.String? = builder.serviceNamespace
    /**
     * The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to access the service.
     *
     * This field is null if no principals attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val totalAuthenticatedEntities: kotlin.Int? = builder.totalAuthenticatedEntities
    /**
     * An object that contains details about the most recent attempt to access a tracked action within the service.
     *
     * This field is null if there no tracked actions or if the principal did not use the tracked actions within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period). This field is also null if the report was generated at the service level and not the action level. For more information, see the `Granularity` field in GenerateServiceLastAccessedDetails.
     */
    public val trackedActionsLastAccessed: List<TrackedActionLastAccessed>? = builder.trackedActionsLastAccessed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServiceLastAccessed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceLastAccessed(")
        append("lastAuthenticated=$lastAuthenticated,")
        append("lastAuthenticatedEntity=$lastAuthenticatedEntity,")
        append("lastAuthenticatedRegion=$lastAuthenticatedRegion,")
        append("serviceName=$serviceName,")
        append("serviceNamespace=$serviceNamespace,")
        append("totalAuthenticatedEntities=$totalAuthenticatedEntities,")
        append("trackedActionsLastAccessed=$trackedActionsLastAccessed)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastAuthenticated?.hashCode() ?: 0
        result = 31 * result + (lastAuthenticatedEntity?.hashCode() ?: 0)
        result = 31 * result + (lastAuthenticatedRegion?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (totalAuthenticatedEntities ?: 0)
        result = 31 * result + (trackedActionsLastAccessed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceLastAccessed

        if (lastAuthenticated != other.lastAuthenticated) return false
        if (lastAuthenticatedEntity != other.lastAuthenticatedEntity) return false
        if (lastAuthenticatedRegion != other.lastAuthenticatedRegion) return false
        if (serviceName != other.serviceName) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (totalAuthenticatedEntities != other.totalAuthenticatedEntities) return false
        if (trackedActionsLastAccessed != other.trackedActionsLastAccessed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServiceLastAccessed = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when an authenticated entity most recently attempted to access the service. Amazon Web Services does not report unauthenticated requests.
         *
         * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var lastAuthenticated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the authenticated entity (user or role) that last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
         *
         * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var lastAuthenticatedEntity: kotlin.String? = null
        /**
         * The Region from which the authenticated entity (user or role) last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
         *
         * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var lastAuthenticatedRegion: kotlin.String? = null
        /**
         * The name of the service in which access was attempted.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The namespace of the service in which access was attempted.
         *
         * To learn the service namespace of a service, see [Actions, resources, and condition keys for Amazon Web Services services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) in the *Service Authorization Reference*. Choose the name of the service to view details for that service. In the first paragraph, find the service prefix. For example, `(service prefix: a4b)`. For more information about service namespaces, see [Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) in the *Amazon Web Services General Reference*.
         */
        public var serviceNamespace: kotlin.String? = null
        /**
         * The total number of authenticated principals (root user, IAM users, or IAM roles) that have attempted to access the service.
         *
         * This field is null if no principals attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var totalAuthenticatedEntities: kotlin.Int? = null
        /**
         * An object that contains details about the most recent attempt to access a tracked action within the service.
         *
         * This field is null if there no tracked actions or if the principal did not use the tracked actions within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period). This field is also null if the report was generated at the service level and not the action level. For more information, see the `Granularity` field in GenerateServiceLastAccessedDetails.
         */
        public var trackedActionsLastAccessed: List<TrackedActionLastAccessed>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServiceLastAccessed) : this() {
            this.lastAuthenticated = x.lastAuthenticated
            this.lastAuthenticatedEntity = x.lastAuthenticatedEntity
            this.lastAuthenticatedRegion = x.lastAuthenticatedRegion
            this.serviceName = x.serviceName
            this.serviceNamespace = x.serviceNamespace
            this.totalAuthenticatedEntities = x.totalAuthenticatedEntities
            this.trackedActionsLastAccessed = x.trackedActionsLastAccessed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServiceLastAccessed = ServiceLastAccessed(this)
    }
}
