// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains additional details about a service-specific credential.
 */
public class ServiceSpecificCredentialMetadata private constructor(builder: Builder) {
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the service-specific credential were created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The name of the service associated with the service-specific credential.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The unique identifier for the service-specific credential.
     */
    public val serviceSpecificCredentialId: kotlin.String? = builder.serviceSpecificCredentialId
    /**
     * The generated user name for the service-specific credential.
     */
    public val serviceUserName: kotlin.String? = builder.serviceUserName
    /**
     * The status of the service-specific credential. `Active` means that the key is valid for API calls, while `Inactive` means it is not.
     */
    public val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The name of the IAM user associated with the service-specific credential.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredentialMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceSpecificCredentialMetadata(")
        append("createDate=$createDate,")
        append("serviceName=$serviceName,")
        append("serviceSpecificCredentialId=$serviceSpecificCredentialId,")
        append("serviceUserName=$serviceUserName,")
        append("status=$status,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createDate?.hashCode() ?: 0
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceSpecificCredentialId?.hashCode() ?: 0)
        result = 31 * result + (serviceUserName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceSpecificCredentialMetadata

        if (createDate != other.createDate) return false
        if (serviceName != other.serviceName) return false
        if (serviceSpecificCredentialId != other.serviceSpecificCredentialId) return false
        if (serviceUserName != other.serviceUserName) return false
        if (status != other.status) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredentialMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the service-specific credential were created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service associated with the service-specific credential.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The unique identifier for the service-specific credential.
         */
        public var serviceSpecificCredentialId: kotlin.String? = null
        /**
         * The generated user name for the service-specific credential.
         */
        public var serviceUserName: kotlin.String? = null
        /**
         * The status of the service-specific credential. `Active` means that the key is valid for API calls, while `Inactive` means it is not.
         */
        public var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The name of the IAM user associated with the service-specific credential.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServiceSpecificCredentialMetadata) : this() {
            this.createDate = x.createDate
            this.serviceName = x.serviceName
            this.serviceSpecificCredentialId = x.serviceSpecificCredentialId
            this.serviceUserName = x.serviceUserName
            this.status = x.status
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServiceSpecificCredentialMetadata = ServiceSpecificCredentialMetadata(this)
    }
}
