// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an SSH public key.
 *
 * This data type is used as a response element in the GetSSHPublicKey and UploadSSHPublicKey operations.
 */
public class SshPublicKey private constructor(builder: Builder) {
    /**
     * The MD5 message digest of the SSH public key.
     */
    public val fingerprint: kotlin.String? = builder.fingerprint
    /**
     * The SSH public key.
     */
    public val sshPublicKeyBody: kotlin.String? = builder.sshPublicKeyBody
    /**
     * The unique identifier for the SSH public key.
     */
    public val sshPublicKeyId: kotlin.String? = builder.sshPublicKeyId
    /**
     * The status of the SSH public key. `Active` means that the key can be used for authentication with an CodeCommit repository. `Inactive` means that the key cannot be used.
     */
    public val status: aws.sdk.kotlin.services.iam.model.StatusType? = builder.status
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the SSH public key was uploaded.
     */
    public val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate
    /**
     * The name of the IAM user associated with the SSH public key.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SshPublicKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SshPublicKey(")
        append("fingerprint=$fingerprint,")
        append("sshPublicKeyBody=$sshPublicKeyBody,")
        append("sshPublicKeyId=$sshPublicKeyId,")
        append("status=$status,")
        append("uploadDate=$uploadDate,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fingerprint?.hashCode() ?: 0
        result = 31 * result + (sshPublicKeyBody?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKeyId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SshPublicKey

        if (fingerprint != other.fingerprint) return false
        if (sshPublicKeyBody != other.sshPublicKeyBody) return false
        if (sshPublicKeyId != other.sshPublicKeyId) return false
        if (status != other.status) return false
        if (uploadDate != other.uploadDate) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SshPublicKey = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The MD5 message digest of the SSH public key.
         */
        public var fingerprint: kotlin.String? = null
        /**
         * The SSH public key.
         */
        public var sshPublicKeyBody: kotlin.String? = null
        /**
         * The unique identifier for the SSH public key.
         */
        public var sshPublicKeyId: kotlin.String? = null
        /**
         * The status of the SSH public key. `Active` means that the key can be used for authentication with an CodeCommit repository. `Inactive` means that the key cannot be used.
         */
        public var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the SSH public key was uploaded.
         */
        public var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the IAM user associated with the SSH public key.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SshPublicKey) : this() {
            this.fingerprint = x.fingerprint
            this.sshPublicKeyBody = x.sshPublicKeyBody
            this.sshPublicKeyId = x.sshPublicKeyId
            this.status = x.status
            this.uploadDate = x.uploadDate
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SshPublicKey = SshPublicKey(this)
    }
}
