// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the most recent attempt to access an action within the service.
 *
 * This data type is used as a response element in the GetServiceLastAccessedDetails operation.
 */
public class TrackedActionLastAccessed private constructor(builder: Builder) {
    /**
     * The name of the tracked action to which access was attempted. Tracked actions are actions that report activity to IAM.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     *
     * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val lastAccessedEntity: kotlin.String? = builder.lastAccessedEntity
    /**
     * The Region from which the authenticated entity (user or role) last attempted to access the tracked action. Amazon Web Services does not report unauthenticated requests.
     *
     * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val lastAccessedRegion: kotlin.String? = builder.lastAccessedRegion
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when an authenticated entity most recently attempted to access the tracked service. Amazon Web Services does not report unauthenticated requests.
     *
     * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
     */
    public val lastAccessedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.TrackedActionLastAccessed = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrackedActionLastAccessed(")
        append("actionName=$actionName,")
        append("lastAccessedEntity=$lastAccessedEntity,")
        append("lastAccessedRegion=$lastAccessedRegion,")
        append("lastAccessedTime=$lastAccessedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (lastAccessedEntity?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrackedActionLastAccessed

        if (actionName != other.actionName) return false
        if (lastAccessedEntity != other.lastAccessedEntity) return false
        if (lastAccessedRegion != other.lastAccessedRegion) return false
        if (lastAccessedTime != other.lastAccessedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.TrackedActionLastAccessed = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the tracked action to which access was attempted. Tracked actions are actions that report activity to IAM.
         */
        public var actionName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         *
         * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var lastAccessedEntity: kotlin.String? = null
        /**
         * The Region from which the authenticated entity (user or role) last attempted to access the tracked action. Amazon Web Services does not report unauthenticated requests.
         *
         * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var lastAccessedRegion: kotlin.String? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when an authenticated entity most recently attempted to access the tracked service. Amazon Web Services does not report unauthenticated requests.
         *
         * This field is null if no IAM entities attempted to access the service within the [tracking period](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
         */
        public var lastAccessedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.TrackedActionLastAccessed) : this() {
            this.actionName = x.actionName
            this.lastAccessedEntity = x.lastAccessedEntity
            this.lastAccessedRegion = x.lastAccessedRegion
            this.lastAccessedTime = x.lastAccessedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.TrackedActionLastAccessed = TrackedActionLastAccessed(this)
    }
}
