// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class UpdateAccountPasswordPolicyRequest private constructor(builder: Builder) {
    /**
     * Allows all IAM users in your account to use the Amazon Web Services Management Console to change their own passwords. For more information, see [Permitting IAM users to change their own passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_enable-user-change.html) in the *IAM User Guide*.
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that IAM users in the account do not automatically have permissions to change their own password.
     */
    public val allowUsersToChangePassword: kotlin.Boolean = builder.allowUsersToChangePassword
    /**
     * Prevents IAM users who are accessing the account via the Amazon Web Services Management Console from setting a new console password after their password has expired. The IAM user cannot access the console until an administrator resets the password.
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that IAM users can change their passwords after they expire and continue to sign in as the user.
     *
     *  In the Amazon Web Services Management Console, the custom password policy option **Allow users to change their own password** gives IAM users permissions to `iam:ChangePassword` for only their user and to the `iam:GetAccountPasswordPolicy` action. This option does not attach a permissions policy to each user, rather the permissions are applied at the account-level for all users by IAM. IAM users with `iam:ChangePassword` permission and active access keys can reset their own expired console password using the CLI or API.
     */
    public val hardExpiry: kotlin.Boolean? = builder.hardExpiry
    /**
     * The number of days that an IAM user password is valid.
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `0`. The result is that IAM user passwords never expire.
     */
    public val maxPasswordAge: kotlin.Int? = builder.maxPasswordAge
    /**
     * The minimum number of characters allowed in an IAM user password.
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `6`.
     */
    public val minimumPasswordLength: kotlin.Int? = builder.minimumPasswordLength
    /**
     * Specifies the number of previous passwords that IAM users are prevented from reusing.
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `0`. The result is that IAM users are not prevented from reusing previous passwords.
     */
    public val passwordReusePrevention: kotlin.Int? = builder.passwordReusePrevention
    /**
     * Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin alphabet (a to z).
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one lowercase character.
     */
    public val requireLowercaseCharacters: kotlin.Boolean = builder.requireLowercaseCharacters
    /**
     * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one numeric character.
     */
    public val requireNumbers: kotlin.Boolean = builder.requireNumbers
    /**
     * Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:
     *
     * ! @ # $ % ^ & * ( ) _ + - = &#91; &#93; { } | '
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one symbol character.
     */
    public val requireSymbols: kotlin.Boolean = builder.requireSymbols
    /**
     * Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin alphabet (A to Z).
     *
     * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one uppercase character.
     */
    public val requireUppercaseCharacters: kotlin.Boolean = builder.requireUppercaseCharacters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccountPasswordPolicyRequest(")
        append("allowUsersToChangePassword=$allowUsersToChangePassword,")
        append("hardExpiry=$hardExpiry,")
        append("maxPasswordAge=$maxPasswordAge,")
        append("minimumPasswordLength=$minimumPasswordLength,")
        append("passwordReusePrevention=$passwordReusePrevention,")
        append("requireLowercaseCharacters=$requireLowercaseCharacters,")
        append("requireNumbers=$requireNumbers,")
        append("requireSymbols=$requireSymbols,")
        append("requireUppercaseCharacters=$requireUppercaseCharacters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUsersToChangePassword.hashCode()
        result = 31 * result + (hardExpiry?.hashCode() ?: 0)
        result = 31 * result + (maxPasswordAge ?: 0)
        result = 31 * result + (minimumPasswordLength ?: 0)
        result = 31 * result + (passwordReusePrevention ?: 0)
        result = 31 * result + (requireLowercaseCharacters.hashCode())
        result = 31 * result + (requireNumbers.hashCode())
        result = 31 * result + (requireSymbols.hashCode())
        result = 31 * result + (requireUppercaseCharacters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccountPasswordPolicyRequest

        if (allowUsersToChangePassword != other.allowUsersToChangePassword) return false
        if (hardExpiry != other.hardExpiry) return false
        if (maxPasswordAge != other.maxPasswordAge) return false
        if (minimumPasswordLength != other.minimumPasswordLength) return false
        if (passwordReusePrevention != other.passwordReusePrevention) return false
        if (requireLowercaseCharacters != other.requireLowercaseCharacters) return false
        if (requireNumbers != other.requireNumbers) return false
        if (requireSymbols != other.requireSymbols) return false
        if (requireUppercaseCharacters != other.requireUppercaseCharacters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows all IAM users in your account to use the Amazon Web Services Management Console to change their own passwords. For more information, see [Permitting IAM users to change their own passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_enable-user-change.html) in the *IAM User Guide*.
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that IAM users in the account do not automatically have permissions to change their own password.
         */
        public var allowUsersToChangePassword: kotlin.Boolean = false
        /**
         * Prevents IAM users who are accessing the account via the Amazon Web Services Management Console from setting a new console password after their password has expired. The IAM user cannot access the console until an administrator resets the password.
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that IAM users can change their passwords after they expire and continue to sign in as the user.
         *
         *  In the Amazon Web Services Management Console, the custom password policy option **Allow users to change their own password** gives IAM users permissions to `iam:ChangePassword` for only their user and to the `iam:GetAccountPasswordPolicy` action. This option does not attach a permissions policy to each user, rather the permissions are applied at the account-level for all users by IAM. IAM users with `iam:ChangePassword` permission and active access keys can reset their own expired console password using the CLI or API.
         */
        public var hardExpiry: kotlin.Boolean? = null
        /**
         * The number of days that an IAM user password is valid.
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `0`. The result is that IAM user passwords never expire.
         */
        public var maxPasswordAge: kotlin.Int? = null
        /**
         * The minimum number of characters allowed in an IAM user password.
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `6`.
         */
        public var minimumPasswordLength: kotlin.Int? = null
        /**
         * Specifies the number of previous passwords that IAM users are prevented from reusing.
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `0`. The result is that IAM users are not prevented from reusing previous passwords.
         */
        public var passwordReusePrevention: kotlin.Int? = null
        /**
         * Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin alphabet (a to z).
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one lowercase character.
         */
        public var requireLowercaseCharacters: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one numeric character.
         */
        public var requireNumbers: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters:
         *
         * ! @ # $ % ^ & * ( ) _ + - = &#91; &#93; { } | '
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one symbol character.
         */
        public var requireSymbols: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin alphabet (A to Z).
         *
         * If you do not specify a value for this parameter, then the operation uses the default value of `false`. The result is that passwords do not require at least one uppercase character.
         */
        public var requireUppercaseCharacters: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyRequest) : this() {
            this.allowUsersToChangePassword = x.allowUsersToChangePassword
            this.hardExpiry = x.hardExpiry
            this.maxPasswordAge = x.maxPasswordAge
            this.minimumPasswordLength = x.minimumPasswordLength
            this.passwordReusePrevention = x.passwordReusePrevention
            this.requireLowercaseCharacters = x.requireLowercaseCharacters
            this.requireNumbers = x.requireNumbers
            this.requireSymbols = x.requireSymbols
            this.requireUppercaseCharacters = x.requireUppercaseCharacters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyRequest = UpdateAccountPasswordPolicyRequest(this)
    }
}
