// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class UpdateRoleRequest private constructor(builder: Builder) {
    /**
     * The new description that you want to apply to the specified role.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
     *
     * Anyone who assumes the role from the CLI or API can use the `DurationSeconds` API parameter or the `duration-seconds` CLI parameter to request a longer session. The `MaxSessionDuration` setting determines the maximum duration that can be requested using the `DurationSeconds` parameter. If users don't specify a value for the `DurationSeconds` parameter, their security credentials are valid for one hour by default. This applies when you use the `AssumeRole*` API operations or the `assume-role*` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
     */
    public val maxSessionDuration: kotlin.Int? = builder.maxSessionDuration
    /**
     * The name of the role that you want to modify.
     */
    public val roleName: kotlin.String? = builder.roleName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.UpdateRoleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRoleRequest(")
        append("description=$description,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("roleName=$roleName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (maxSessionDuration ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRoleRequest

        if (description != other.description) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (roleName != other.roleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.UpdateRoleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The new description that you want to apply to the specified role.
         */
        public var description: kotlin.String? = null
        /**
         * The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12 hours.
         *
         * Anyone who assumes the role from the CLI or API can use the `DurationSeconds` API parameter or the `duration-seconds` CLI parameter to request a longer session. The `MaxSessionDuration` setting determines the maximum duration that can be requested using the `DurationSeconds` parameter. If users don't specify a value for the `DurationSeconds` parameter, their security credentials are valid for one hour by default. This applies when you use the `AssumeRole*` API operations or the `assume-role*` CLI operations but does not apply when you use those operations to create a console URL. For more information, see [Using IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) in the *IAM User Guide*.
         */
        public var maxSessionDuration: kotlin.Int? = null
        /**
         * The name of the role that you want to modify.
         */
        public var roleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.UpdateRoleRequest) : this() {
            this.description = x.description
            this.maxSessionDuration = x.maxSessionDuration
            this.roleName = x.roleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.UpdateRoleRequest = UpdateRoleRequest(this)
    }
}
