// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.paginators

import aws.sdk.kotlin.services.iam.IamClient
import aws.sdk.kotlin.services.iam.model.AccessKeyMetadata
import aws.sdk.kotlin.services.iam.model.AttachedPolicy
import aws.sdk.kotlin.services.iam.model.EvaluationResult
import aws.sdk.kotlin.services.iam.model.GetAccountAuthorizationDetailsRequest
import aws.sdk.kotlin.services.iam.model.GetAccountAuthorizationDetailsResponse
import aws.sdk.kotlin.services.iam.model.GetGroupRequest
import aws.sdk.kotlin.services.iam.model.GetGroupResponse
import aws.sdk.kotlin.services.iam.model.Group
import aws.sdk.kotlin.services.iam.model.InstanceProfile
import aws.sdk.kotlin.services.iam.model.ListAccessKeysRequest
import aws.sdk.kotlin.services.iam.model.ListAccessKeysResponse
import aws.sdk.kotlin.services.iam.model.ListAccountAliasesRequest
import aws.sdk.kotlin.services.iam.model.ListAccountAliasesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedGroupPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedGroupPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedRolePoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedRolePoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedUserPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedUserPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyRequest
import aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse
import aws.sdk.kotlin.services.iam.model.ListGroupPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListGroupPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListGroupsForUserRequest
import aws.sdk.kotlin.services.iam.model.ListGroupsForUserResponse
import aws.sdk.kotlin.services.iam.model.ListGroupsRequest
import aws.sdk.kotlin.services.iam.model.ListGroupsResponse
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesForRoleRequest
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesForRoleResponse
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesRequest
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesResponse
import aws.sdk.kotlin.services.iam.model.ListMfaDevicesRequest
import aws.sdk.kotlin.services.iam.model.ListMfaDevicesResponse
import aws.sdk.kotlin.services.iam.model.ListPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListPolicyVersionsRequest
import aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse
import aws.sdk.kotlin.services.iam.model.ListRolePoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListRolePoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListRolesRequest
import aws.sdk.kotlin.services.iam.model.ListRolesResponse
import aws.sdk.kotlin.services.iam.model.ListServerCertificatesRequest
import aws.sdk.kotlin.services.iam.model.ListServerCertificatesResponse
import aws.sdk.kotlin.services.iam.model.ListSigningCertificatesRequest
import aws.sdk.kotlin.services.iam.model.ListSigningCertificatesResponse
import aws.sdk.kotlin.services.iam.model.ListSshPublicKeysRequest
import aws.sdk.kotlin.services.iam.model.ListSshPublicKeysResponse
import aws.sdk.kotlin.services.iam.model.ListUserPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListUserPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListUserTagsRequest
import aws.sdk.kotlin.services.iam.model.ListUserTagsResponse
import aws.sdk.kotlin.services.iam.model.ListUsersRequest
import aws.sdk.kotlin.services.iam.model.ListUsersResponse
import aws.sdk.kotlin.services.iam.model.ListVirtualMfaDevicesRequest
import aws.sdk.kotlin.services.iam.model.ListVirtualMfaDevicesResponse
import aws.sdk.kotlin.services.iam.model.MfaDevice
import aws.sdk.kotlin.services.iam.model.Policy
import aws.sdk.kotlin.services.iam.model.PolicyVersion
import aws.sdk.kotlin.services.iam.model.Role
import aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata
import aws.sdk.kotlin.services.iam.model.SigningCertificate
import aws.sdk.kotlin.services.iam.model.SimulateCustomPolicyRequest
import aws.sdk.kotlin.services.iam.model.SimulateCustomPolicyResponse
import aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest
import aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyResponse
import aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata
import aws.sdk.kotlin.services.iam.model.Tag
import aws.sdk.kotlin.services.iam.model.User
import aws.sdk.kotlin.services.iam.model.VirtualMfaDevice
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetAccountAuthorizationDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetAccountAuthorizationDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAccountAuthorizationDetailsResponse]
 */
public fun IamClient.getAccountAuthorizationDetailsPaginated(initialRequest: GetAccountAuthorizationDetailsRequest): Flow<GetAccountAuthorizationDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@getAccountAuthorizationDetailsPaginated.getAccountAuthorizationDetails(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [GetAccountAuthorizationDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAccountAuthorizationDetailsResponse]
 */
public fun IamClient.getAccountAuthorizationDetailsPaginated(block: GetAccountAuthorizationDetailsRequest.Builder.() -> Unit): Flow<GetAccountAuthorizationDetailsResponse> =
    getAccountAuthorizationDetailsPaginated(GetAccountAuthorizationDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetGroupRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetGroupResponse]
 */
public fun IamClient.getGroupPaginated(initialRequest: GetGroupRequest): Flow<GetGroupResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@getGroupPaginated.getGroup(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [GetGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetGroupResponse]
 */
public fun IamClient.getGroupPaginated(block: GetGroupRequest.Builder.() -> Unit): Flow<GetGroupResponse> =
    getGroupPaginated(GetGroupRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getGroupPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("getGroupResponseUser")
public fun Flow<GetGroupResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccessKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessKeysResponse]
 */
public fun IamClient.listAccessKeysPaginated(initialRequest: ListAccessKeysRequest): Flow<ListAccessKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAccessKeysPaginated.listAccessKeys(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessKeysResponse]
 */
public fun IamClient.listAccessKeysPaginated(block: ListAccessKeysRequest.Builder.() -> Unit): Flow<ListAccessKeysResponse> =
    listAccessKeysPaginated(ListAccessKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessKeysPaginated]
 * to access the nested member [AccessKeyMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessKeyMetadata]
 */
@JvmName("listAccessKeysResponseAccessKeyMetadata")
public fun Flow<ListAccessKeysResponse>.accessKeyMetadata(): Flow<AccessKeyMetadata> =
    transform() { response ->
        response.accessKeyMetadata?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAliasesResponse]
 */
public fun IamClient.listAccountAliasesPaginated(initialRequest: ListAccountAliasesRequest): Flow<ListAccountAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAccountAliasesPaginated.listAccountAliases(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAliasesResponse]
 */
public fun IamClient.listAccountAliasesPaginated(block: ListAccountAliasesRequest.Builder.() -> Unit): Flow<ListAccountAliasesResponse> =
    listAccountAliasesPaginated(ListAccountAliasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountAliasesPaginated]
 * to access the nested member [AccountAliasType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAliasType]
 */
@JvmName("listAccountAliasesResponseAccountAliasType")
public fun Flow<ListAccountAliasesResponse>.accountAliases(): Flow<String> =
    transform() { response ->
        response.accountAliases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttachedGroupPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttachedGroupPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedGroupPoliciesResponse]
 */
public fun IamClient.listAttachedGroupPoliciesPaginated(initialRequest: ListAttachedGroupPoliciesRequest): Flow<ListAttachedGroupPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAttachedGroupPoliciesPaginated.listAttachedGroupPolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListAttachedGroupPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedGroupPoliciesResponse]
 */
public fun IamClient.listAttachedGroupPoliciesPaginated(block: ListAttachedGroupPoliciesRequest.Builder.() -> Unit): Flow<ListAttachedGroupPoliciesResponse> =
    listAttachedGroupPoliciesPaginated(ListAttachedGroupPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttachedGroupPoliciesPaginated]
 * to access the nested member [AttachedPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttachedPolicy]
 */
@JvmName("listAttachedGroupPoliciesResponseAttachedPolicy")
public fun Flow<ListAttachedGroupPoliciesResponse>.attachedPolicies(): Flow<AttachedPolicy> =
    transform() { response ->
        response.attachedPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttachedRolePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttachedRolePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedRolePoliciesResponse]
 */
public fun IamClient.listAttachedRolePoliciesPaginated(initialRequest: ListAttachedRolePoliciesRequest): Flow<ListAttachedRolePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAttachedRolePoliciesPaginated.listAttachedRolePolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListAttachedRolePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedRolePoliciesResponse]
 */
public fun IamClient.listAttachedRolePoliciesPaginated(block: ListAttachedRolePoliciesRequest.Builder.() -> Unit): Flow<ListAttachedRolePoliciesResponse> =
    listAttachedRolePoliciesPaginated(ListAttachedRolePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttachedRolePoliciesPaginated]
 * to access the nested member [AttachedPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttachedPolicy]
 */
@JvmName("listAttachedRolePoliciesResponseAttachedPolicy")
public fun Flow<ListAttachedRolePoliciesResponse>.attachedPolicies(): Flow<AttachedPolicy> =
    transform() { response ->
        response.attachedPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttachedUserPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttachedUserPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedUserPoliciesResponse]
 */
public fun IamClient.listAttachedUserPoliciesPaginated(initialRequest: ListAttachedUserPoliciesRequest): Flow<ListAttachedUserPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAttachedUserPoliciesPaginated.listAttachedUserPolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListAttachedUserPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedUserPoliciesResponse]
 */
public fun IamClient.listAttachedUserPoliciesPaginated(block: ListAttachedUserPoliciesRequest.Builder.() -> Unit): Flow<ListAttachedUserPoliciesResponse> =
    listAttachedUserPoliciesPaginated(ListAttachedUserPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttachedUserPoliciesPaginated]
 * to access the nested member [AttachedPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttachedPolicy]
 */
@JvmName("listAttachedUserPoliciesResponseAttachedPolicy")
public fun Flow<ListAttachedUserPoliciesResponse>.attachedPolicies(): Flow<AttachedPolicy> =
    transform() { response ->
        response.attachedPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEntitiesForPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntitiesForPolicyRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesForPolicyResponse]
 */
public fun IamClient.listEntitiesForPolicyPaginated(initialRequest: ListEntitiesForPolicyRequest): Flow<ListEntitiesForPolicyResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listEntitiesForPolicyPaginated.listEntitiesForPolicy(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListEntitiesForPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesForPolicyResponse]
 */
public fun IamClient.listEntitiesForPolicyPaginated(block: ListEntitiesForPolicyRequest.Builder.() -> Unit): Flow<ListEntitiesForPolicyResponse> =
    listEntitiesForPolicyPaginated(ListEntitiesForPolicyRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGroupPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupPoliciesResponse]
 */
public fun IamClient.listGroupPoliciesPaginated(initialRequest: ListGroupPoliciesRequest): Flow<ListGroupPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listGroupPoliciesPaginated.listGroupPolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupPoliciesResponse]
 */
public fun IamClient.listGroupPoliciesPaginated(block: ListGroupPoliciesRequest.Builder.() -> Unit): Flow<ListGroupPoliciesResponse> =
    listGroupPoliciesPaginated(ListGroupPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupPoliciesPaginated]
 * to access the nested member [PolicyNameType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyNameType]
 */
@JvmName("listGroupPoliciesResponsePolicyNameType")
public fun Flow<ListGroupPoliciesResponse>.policyNames(): Flow<String> =
    transform() { response ->
        response.policyNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun IamClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun IamClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsPaginated]
 * to access the nested member [Group]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Group]
 */
@JvmName("listGroupsResponseGroup")
public fun Flow<ListGroupsResponse>.groups(): Flow<Group> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsForUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsForUserRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsForUserResponse]
 */
public fun IamClient.listGroupsForUserPaginated(initialRequest: ListGroupsForUserRequest): Flow<ListGroupsForUserResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listGroupsForUserPaginated.listGroupsForUser(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsForUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsForUserResponse]
 */
public fun IamClient.listGroupsForUserPaginated(block: ListGroupsForUserRequest.Builder.() -> Unit): Flow<ListGroupsForUserResponse> =
    listGroupsForUserPaginated(ListGroupsForUserRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsForUserPaginated]
 * to access the nested member [Group]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Group]
 */
@JvmName("listGroupsForUserResponseGroup")
public fun Flow<ListGroupsForUserResponse>.groups(): Flow<Group> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceProfilesResponse]
 */
public fun IamClient.listInstanceProfilesPaginated(initialRequest: ListInstanceProfilesRequest): Flow<ListInstanceProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInstanceProfilesPaginated.listInstanceProfiles(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceProfilesResponse]
 */
public fun IamClient.listInstanceProfilesPaginated(block: ListInstanceProfilesRequest.Builder.() -> Unit): Flow<ListInstanceProfilesResponse> =
    listInstanceProfilesPaginated(ListInstanceProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceProfilesPaginated]
 * to access the nested member [InstanceProfile]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceProfile]
 */
@JvmName("listInstanceProfilesResponseInstanceProfile")
public fun Flow<ListInstanceProfilesResponse>.instanceProfiles(): Flow<InstanceProfile> =
    transform() { response ->
        response.instanceProfiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceProfilesForRoleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceProfilesForRoleRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceProfilesForRoleResponse]
 */
public fun IamClient.listInstanceProfilesForRolePaginated(initialRequest: ListInstanceProfilesForRoleRequest): Flow<ListInstanceProfilesForRoleResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInstanceProfilesForRolePaginated.listInstanceProfilesForRole(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceProfilesForRoleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceProfilesForRoleResponse]
 */
public fun IamClient.listInstanceProfilesForRolePaginated(block: ListInstanceProfilesForRoleRequest.Builder.() -> Unit): Flow<ListInstanceProfilesForRoleResponse> =
    listInstanceProfilesForRolePaginated(ListInstanceProfilesForRoleRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceProfilesForRolePaginated]
 * to access the nested member [InstanceProfile]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceProfile]
 */
@JvmName("listInstanceProfilesForRoleResponseInstanceProfile")
public fun Flow<ListInstanceProfilesForRoleResponse>.instanceProfiles(): Flow<InstanceProfile> =
    transform() { response ->
        response.instanceProfiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMfaDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMfaDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMfaDevicesResponse]
 */
public fun IamClient.listMfaDevicesPaginated(initialRequest: ListMfaDevicesRequest): Flow<ListMfaDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listMfaDevicesPaginated.listMfaDevices(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListMfaDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMfaDevicesResponse]
 */
public fun IamClient.listMfaDevicesPaginated(block: ListMfaDevicesRequest.Builder.() -> Unit): Flow<ListMfaDevicesResponse> =
    listMfaDevicesPaginated(ListMfaDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMfaDevicesPaginated]
 * to access the nested member [MfaDevice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MfaDevice]
 */
@JvmName("listMfaDevicesResponseMfaDevice")
public fun Flow<ListMfaDevicesResponse>.mfaDevices(): Flow<MfaDevice> =
    transform() { response ->
        response.mfaDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun IamClient.listPoliciesPaginated(initialRequest: ListPoliciesRequest): Flow<ListPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listPoliciesPaginated.listPolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun IamClient.listPoliciesPaginated(block: ListPoliciesRequest.Builder.() -> Unit): Flow<ListPoliciesResponse> =
    listPoliciesPaginated(ListPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPoliciesPaginated]
 * to access the nested member [Policy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Policy]
 */
@JvmName("listPoliciesResponsePolicy")
public fun Flow<ListPoliciesResponse>.policies(): Flow<Policy> =
    transform() { response ->
        response.policies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPolicyVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPolicyVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyVersionsResponse]
 */
public fun IamClient.listPolicyVersionsPaginated(initialRequest: ListPolicyVersionsRequest): Flow<ListPolicyVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listPolicyVersionsPaginated.listPolicyVersions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListPolicyVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyVersionsResponse]
 */
public fun IamClient.listPolicyVersionsPaginated(block: ListPolicyVersionsRequest.Builder.() -> Unit): Flow<ListPolicyVersionsResponse> =
    listPolicyVersionsPaginated(ListPolicyVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPolicyVersionsPaginated]
 * to access the nested member [PolicyVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyVersion]
 */
@JvmName("listPolicyVersionsResponsePolicyVersion")
public fun Flow<ListPolicyVersionsResponse>.versions(): Flow<PolicyVersion> =
    transform() { response ->
        response.versions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRolePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRolePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRolePoliciesResponse]
 */
public fun IamClient.listRolePoliciesPaginated(initialRequest: ListRolePoliciesRequest): Flow<ListRolePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listRolePoliciesPaginated.listRolePolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListRolePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRolePoliciesResponse]
 */
public fun IamClient.listRolePoliciesPaginated(block: ListRolePoliciesRequest.Builder.() -> Unit): Flow<ListRolePoliciesResponse> =
    listRolePoliciesPaginated(ListRolePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRolePoliciesPaginated]
 * to access the nested member [PolicyNameType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyNameType]
 */
@JvmName("listRolePoliciesResponsePolicyNameType")
public fun Flow<ListRolePoliciesResponse>.policyNames(): Flow<String> =
    transform() { response ->
        response.policyNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRolesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRolesResponse]
 */
public fun IamClient.listRolesPaginated(initialRequest: ListRolesRequest): Flow<ListRolesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listRolesPaginated.listRoles(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRolesResponse]
 */
public fun IamClient.listRolesPaginated(block: ListRolesRequest.Builder.() -> Unit): Flow<ListRolesResponse> =
    listRolesPaginated(ListRolesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRolesPaginated]
 * to access the nested member [Role]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Role]
 */
@JvmName("listRolesResponseRole")
public fun Flow<ListRolesResponse>.roles(): Flow<Role> =
    transform() { response ->
        response.roles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServerCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServerCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServerCertificatesResponse]
 */
public fun IamClient.listServerCertificatesPaginated(initialRequest: ListServerCertificatesRequest): Flow<ListServerCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listServerCertificatesPaginated.listServerCertificates(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListServerCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServerCertificatesResponse]
 */
public fun IamClient.listServerCertificatesPaginated(block: ListServerCertificatesRequest.Builder.() -> Unit): Flow<ListServerCertificatesResponse> =
    listServerCertificatesPaginated(ListServerCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServerCertificatesPaginated]
 * to access the nested member [ServerCertificateMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServerCertificateMetadata]
 */
@JvmName("listServerCertificatesResponseServerCertificateMetadata")
public fun Flow<ListServerCertificatesResponse>.serverCertificateMetadataList(): Flow<ServerCertificateMetadata> =
    transform() { response ->
        response.serverCertificateMetadataList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSigningCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSigningCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningCertificatesResponse]
 */
public fun IamClient.listSigningCertificatesPaginated(initialRequest: ListSigningCertificatesRequest): Flow<ListSigningCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listSigningCertificatesPaginated.listSigningCertificates(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListSigningCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningCertificatesResponse]
 */
public fun IamClient.listSigningCertificatesPaginated(block: ListSigningCertificatesRequest.Builder.() -> Unit): Flow<ListSigningCertificatesResponse> =
    listSigningCertificatesPaginated(ListSigningCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSigningCertificatesPaginated]
 * to access the nested member [SigningCertificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SigningCertificate]
 */
@JvmName("listSigningCertificatesResponseSigningCertificate")
public fun Flow<ListSigningCertificatesResponse>.certificates(): Flow<SigningCertificate> =
    transform() { response ->
        response.certificates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSshPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSshPublicKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSshPublicKeysResponse]
 */
public fun IamClient.listSshPublicKeysPaginated(initialRequest: ListSshPublicKeysRequest): Flow<ListSshPublicKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listSshPublicKeysPaginated.listSshPublicKeys(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListSshPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSshPublicKeysResponse]
 */
public fun IamClient.listSshPublicKeysPaginated(block: ListSshPublicKeysRequest.Builder.() -> Unit): Flow<ListSshPublicKeysResponse> =
    listSshPublicKeysPaginated(ListSshPublicKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSshPublicKeysPaginated]
 * to access the nested member [SshPublicKeyMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SshPublicKeyMetadata]
 */
@JvmName("listSshPublicKeysResponseSshPublicKeyMetadata")
public fun Flow<ListSshPublicKeysResponse>.sshPublicKeys(): Flow<SshPublicKeyMetadata> =
    transform() { response ->
        response.sshPublicKeys?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoliciesResponse]
 */
public fun IamClient.listUserPoliciesPaginated(initialRequest: ListUserPoliciesRequest): Flow<ListUserPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listUserPoliciesPaginated.listUserPolicies(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListUserPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoliciesResponse]
 */
public fun IamClient.listUserPoliciesPaginated(block: ListUserPoliciesRequest.Builder.() -> Unit): Flow<ListUserPoliciesResponse> =
    listUserPoliciesPaginated(ListUserPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserPoliciesPaginated]
 * to access the nested member [PolicyNameType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyNameType]
 */
@JvmName("listUserPoliciesResponsePolicyNameType")
public fun Flow<ListUserPoliciesResponse>.policyNames(): Flow<String> =
    transform() { response ->
        response.policyNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun IamClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun IamClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("listUsersResponseUser")
public fun Flow<ListUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserTagsResponse]
 */
public fun IamClient.listUserTagsPaginated(initialRequest: ListUserTagsRequest): Flow<ListUserTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listUserTagsPaginated.listUserTags(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListUserTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserTagsResponse]
 */
public fun IamClient.listUserTagsPaginated(block: ListUserTagsRequest.Builder.() -> Unit): Flow<ListUserTagsResponse> =
    listUserTagsPaginated(ListUserTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserTagsPaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listUserTagsResponseTag")
public fun Flow<ListUserTagsResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVirtualMfaDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVirtualMfaDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMfaDevicesResponse]
 */
public fun IamClient.listVirtualMfaDevicesPaginated(initialRequest: ListVirtualMfaDevicesRequest): Flow<ListVirtualMfaDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listVirtualMfaDevicesPaginated.listVirtualMfaDevices(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListVirtualMfaDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualMfaDevicesResponse]
 */
public fun IamClient.listVirtualMfaDevicesPaginated(block: ListVirtualMfaDevicesRequest.Builder.() -> Unit): Flow<ListVirtualMfaDevicesResponse> =
    listVirtualMfaDevicesPaginated(ListVirtualMfaDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVirtualMfaDevicesPaginated]
 * to access the nested member [VirtualMfaDevice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VirtualMfaDevice]
 */
@JvmName("listVirtualMfaDevicesResponseVirtualMfaDevice")
public fun Flow<ListVirtualMfaDevicesResponse>.virtualMfaDevices(): Flow<VirtualMfaDevice> =
    transform() { response ->
        response.virtualMfaDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SimulateCustomPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SimulateCustomPolicyRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulateCustomPolicyResponse]
 */
public fun IamClient.simulateCustomPolicyPaginated(initialRequest: SimulateCustomPolicyRequest): Flow<SimulateCustomPolicyResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@simulateCustomPolicyPaginated.simulateCustomPolicy(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [SimulateCustomPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulateCustomPolicyResponse]
 */
public fun IamClient.simulateCustomPolicyPaginated(block: SimulateCustomPolicyRequest.Builder.() -> Unit): Flow<SimulateCustomPolicyResponse> =
    simulateCustomPolicyPaginated(SimulateCustomPolicyRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [simulateCustomPolicyPaginated]
 * to access the nested member [EvaluationResult]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EvaluationResult]
 */
@JvmName("simulateCustomPolicyResponseEvaluationResult")
public fun Flow<SimulateCustomPolicyResponse>.evaluationResults(): Flow<EvaluationResult> =
    transform() { response ->
        response.evaluationResults?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SimulatePrincipalPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SimulatePrincipalPolicyRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulatePrincipalPolicyResponse]
 */
public fun IamClient.simulatePrincipalPolicyPaginated(initialRequest: SimulatePrincipalPolicyRequest): Flow<SimulatePrincipalPolicyResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@simulatePrincipalPolicyPaginated.simulatePrincipalPolicy(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [SimulatePrincipalPolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SimulatePrincipalPolicyResponse]
 */
public fun IamClient.simulatePrincipalPolicyPaginated(block: SimulatePrincipalPolicyRequest.Builder.() -> Unit): Flow<SimulatePrincipalPolicyResponse> =
    simulatePrincipalPolicyPaginated(SimulatePrincipalPolicyRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [simulatePrincipalPolicyPaginated]
 * to access the nested member [EvaluationResult]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EvaluationResult]
 */
@JvmName("simulatePrincipalPolicyResponseEvaluationResult")
public fun Flow<SimulatePrincipalPolicyResponse>.evaluationResults(): Flow<EvaluationResult> =
    transform() { response ->
        response.evaluationResults?.forEach {
            emit(it)
        }
    }
