// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOpenIDConnectProviderOperationSerializer: HttpSerialize<CreateOpenIdConnectProviderRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateOpenIdConnectProviderRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateOpenIDConnectProviderOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateOpenIDConnectProviderOperationBody(context: ExecutionContext, input: CreateOpenIdConnectProviderRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CLIENTIDLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ClientIDList"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val THUMBPRINTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ThumbprintList"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateOpenIDConnectProviderRequest"))
        trait(QueryLiteral("Action", "CreateOpenIDConnectProvider"))
        trait(QueryLiteral("Version", "2010-05-08"))
        field(CLIENTIDLIST_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THUMBPRINTLIST_DESCRIPTOR)
        field(URL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.clientIdList != null) {
            listField(CLIENTIDLIST_DESCRIPTOR) {
                for (el0 in input.clientIdList) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        if (input.thumbprintList != null) {
            listField(THUMBPRINTLIST_DESCRIPTOR) {
                for (el0 in input.thumbprintList) {
                    serializeString(el0)
                }
            }
        }
        input.url?.let { field(URL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
