// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.iam.model.AccessKeyLastUsed
import aws.sdk.kotlin.services.iam.model.GetAccessKeyLastUsedResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetAccessKeyLastUsedOperationDeserializer: HttpDeserialize<GetAccessKeyLastUsedResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAccessKeyLastUsedResponse {
        if (!response.status.isSuccess()) {
            throwGetAccessKeyLastUsedError(context, response)
        }
        val builder = GetAccessKeyLastUsedResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccessKeyLastUsedOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAccessKeyLastUsedError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessKeyLastUsedOperationBody(builder: GetAccessKeyLastUsedResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetAccessKeyLastUsedResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetAccessKeyLastUsedResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetAccessKeyLastUsed response")
    }
    // end unwrap response wrapper

    val ACCESSKEYLASTUSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AccessKeyLastUsed"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetAccessKeyLastUsedResult"))
        field(ACCESSKEYLASTUSED_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSKEYLASTUSED_DESCRIPTOR.index -> builder.accessKeyLastUsed = deserializeAccessKeyLastUsedDocument(deserializer)
                USERNAME_DESCRIPTOR.index -> builder.userName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
