// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse
import aws.sdk.kotlin.services.iam.model.PolicyGroup
import aws.sdk.kotlin.services.iam.model.PolicyRole
import aws.sdk.kotlin.services.iam.model.PolicyUser
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListEntitiesForPolicyOperationDeserializer: HttpDeserialize<ListEntitiesForPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListEntitiesForPolicyResponse {
        if (!response.status.isSuccess()) {
            throwListEntitiesForPolicyError(context, response)
        }
        val builder = ListEntitiesForPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListEntitiesForPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListEntitiesForPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListEntitiesForPolicyOperationBody(builder: ListEntitiesForPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ListEntitiesForPolicyResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListEntitiesForPolicyResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ListEntitiesForPolicy response")
    }
    // end unwrap response wrapper

    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val POLICYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("PolicyGroups"))
    val POLICYROLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("PolicyRoles"))
    val POLICYUSERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("PolicyUsers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("ListEntitiesForPolicyResult"))
        field(ISTRUNCATED_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(POLICYGROUPS_DESCRIPTOR)
        field(POLICYROLES_DESCRIPTOR)
        field(POLICYUSERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                POLICYGROUPS_DESCRIPTOR.index -> builder.policyGroups =
                    deserializer.deserializeList(POLICYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<PolicyGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POLICYROLES_DESCRIPTOR.index -> builder.policyRoles =
                    deserializer.deserializeList(POLICYROLES_DESCRIPTOR) {
                        val col0 = mutableListOf<PolicyRole>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyRoleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POLICYUSERS_DESCRIPTOR.index -> builder.policyUsers =
                    deserializer.deserializeList(POLICYUSERS_DESCRIPTOR) {
                        val col0 = mutableListOf<PolicyUser>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyUserDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
