// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.waiters

import aws.sdk.kotlin.services.iam.IamClient
import aws.sdk.kotlin.services.iam.model.GetInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.GetInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.GetPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetRoleRequest
import aws.sdk.kotlin.services.iam.model.GetRoleResponse
import aws.sdk.kotlin.services.iam.model.GetUserRequest
import aws.sdk.kotlin.services.iam.model.GetUserResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import kotlin.time.Duration.Companion.milliseconds


public suspend fun IamClient.waitUntilInstanceProfileExists(request: GetInstanceProfileRequest): Outcome<GetInstanceProfileResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetInstanceProfileRequest, GetInstanceProfileResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NoSuchEntityException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getInstanceProfile(request) }
}

public suspend fun IamClient.waitUntilInstanceProfileExists(block: GetInstanceProfileRequest.Builder.() -> Unit): Outcome<GetInstanceProfileResponse> =
    waitUntilInstanceProfileExists(GetInstanceProfileRequest.Builder().apply(block).build())

public suspend fun IamClient.waitUntilPolicyExists(request: GetPolicyRequest): Outcome<GetPolicyResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetPolicyRequest, GetPolicyResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NoSuchEntity"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getPolicy(request) }
}

public suspend fun IamClient.waitUntilPolicyExists(block: GetPolicyRequest.Builder.() -> Unit): Outcome<GetPolicyResponse> =
    waitUntilPolicyExists(GetPolicyRequest.Builder().apply(block).build())

public suspend fun IamClient.waitUntilRoleExists(request: GetRoleRequest): Outcome<GetRoleResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetRoleRequest, GetRoleResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NoSuchEntity"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getRole(request) }
}

public suspend fun IamClient.waitUntilRoleExists(block: GetRoleRequest.Builder.() -> Unit): Outcome<GetRoleResponse> =
    waitUntilRoleExists(GetRoleRequest.Builder().apply(block).build())

public suspend fun IamClient.waitUntilUserExists(request: GetUserRequest): Outcome<GetUserResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetUserRequest, GetUserResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NoSuchEntity"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getUser(request) }
}

public suspend fun IamClient.waitUntilUserExists(block: GetUserRequest.Builder.() -> Unit): Outcome<GetUserResponse> =
    waitUntilUserExists(GetUserRequest.Builder().apply(block).build())
