// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.endpoints

import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.util.Attributes
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region aws-cn-global with FIPS disabled and DualStack disabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "aws-cn-global"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://iam.cn-north-1.amazonaws.com.cn"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "iam",
                            disableDoubleEncoding = false,
                            signingRegion = "cn-north-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region aws-global with FIPS disabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "aws-global"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://iam.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "iam",
                            disableDoubleEncoding = false,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region aws-iso-global with FIPS disabled and DualStack disabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "aws-iso-global"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://iam.us-iso-east-1.c2s.ic.gov"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "iam",
                            disableDoubleEncoding = false,
                            signingRegion = "us-iso-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region aws-iso-b-global with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "aws-iso-b-global"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://iam.us-isob-east-1.sc2s.sgov.gov"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "iam",
                            disableDoubleEncoding = false,
                            signingRegion = "us-isob-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region aws-us-gov-global with FIPS disabled and DualStack disabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "aws-us-gov-global"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://iam.us-gov.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "iam",
                            disableDoubleEncoding = false,
                            signingRegion = "us-gov-west-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-1"
            useDualStack = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
