// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.imagebuilder.model.*
import aws.sdk.kotlin.services.imagebuilder.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "imagebuilder"
public const val ServiceApiVersion: String = "2019-12-02"
public const val SdkVersion: String = "0.17.3-beta"

internal class DefaultImagebuilderClient(override val config: ImagebuilderClient.Config) : ImagebuilderClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
     */
    override suspend fun cancelImageCreation(input: CancelImageCreationRequest): CancelImageCreationResponse {
        val op = SdkHttpOperation.build<CancelImageCreationRequest, CancelImageCreationResponse> {
            serializer = CancelImageCreationOperationSerializer()
            deserializer = CancelImageCreationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelImageCreation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
     * + Inline, using the `data` property in the request body.
     * + A URL that points to a YAML document file stored in Amazon S3, using the `uri` property in the request body.
     */
    override suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse {
        val op = SdkHttpOperation.build<CreateComponentRequest, CreateComponentResponse> {
            serializer = CreateComponentOperationSerializer()
            deserializer = CreateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     */
    override suspend fun createContainerRecipe(input: CreateContainerRecipeRequest): CreateContainerRecipeResponse {
        val op = SdkHttpOperation.build<CreateContainerRecipeRequest, CreateContainerRecipeResponse> {
            serializer = CreateContainerRecipeOperationSerializer()
            deserializer = CreateContainerRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContainerRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    override suspend fun createDistributionConfiguration(input: CreateDistributionConfigurationRequest): CreateDistributionConfigurationResponse {
        val op = SdkHttpOperation.build<CreateDistributionConfigurationRequest, CreateDistributionConfigurationResponse> {
            serializer = CreateDistributionConfigurationOperationSerializer()
            deserializer = CreateDistributionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDistributionConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
     */
    override suspend fun createImage(input: CreateImageRequest): CreateImageResponse {
        val op = SdkHttpOperation.build<CreateImageRequest, CreateImageResponse> {
            serializer = CreateImageOperationSerializer()
            deserializer = CreateImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     */
    override suspend fun createImagePipeline(input: CreateImagePipelineRequest): CreateImagePipelineResponse {
        val op = SdkHttpOperation.build<CreateImagePipelineRequest, CreateImagePipelineResponse> {
            serializer = CreateImagePipelineOperationSerializer()
            deserializer = CreateImagePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImagePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     */
    override suspend fun createImageRecipe(input: CreateImageRecipeRequest): CreateImageRecipeResponse {
        val op = SdkHttpOperation.build<CreateImageRecipeRequest, CreateImageRecipeResponse> {
            serializer = CreateImageRecipeOperationSerializer()
            deserializer = CreateImageRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImageRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    override suspend fun createInfrastructureConfiguration(input: CreateInfrastructureConfigurationRequest): CreateInfrastructureConfigurationResponse {
        val op = SdkHttpOperation.build<CreateInfrastructureConfigurationRequest, CreateInfrastructureConfigurationResponse> {
            serializer = CreateInfrastructureConfigurationOperationSerializer()
            deserializer = CreateInfrastructureConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInfrastructureConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a component build version.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a container recipe.
     */
    override suspend fun deleteContainerRecipe(input: DeleteContainerRecipeRequest): DeleteContainerRecipeResponse {
        val op = SdkHttpOperation.build<DeleteContainerRecipeRequest, DeleteContainerRecipeResponse> {
            serializer = DeleteContainerRecipeOperationSerializer()
            deserializer = DeleteContainerRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContainerRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a distribution configuration.
     */
    override suspend fun deleteDistributionConfiguration(input: DeleteDistributionConfigurationRequest): DeleteDistributionConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteDistributionConfigurationRequest, DeleteDistributionConfigurationResponse> {
            serializer = DeleteDistributionConfigurationOperationSerializer()
            deserializer = DeleteDistributionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDistributionConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
     * + To deregister an EC2 Linux AMI, see [Deregister your Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html) in the **Amazon EC2 User Guide**.
     * + To deregister an EC2 Windows AMI, see [Deregister your Windows AMI](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html) in the **Amazon EC2 Windows Guide**.
     * + To delete a container image from Amazon ECR, see [Deleting an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html) in the *Amazon ECR User Guide*.
     */
    override suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse {
        val op = SdkHttpOperation.build<DeleteImageRequest, DeleteImageResponse> {
            serializer = DeleteImageOperationSerializer()
            deserializer = DeleteImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an image pipeline.
     */
    override suspend fun deleteImagePipeline(input: DeleteImagePipelineRequest): DeleteImagePipelineResponse {
        val op = SdkHttpOperation.build<DeleteImagePipelineRequest, DeleteImagePipelineResponse> {
            serializer = DeleteImagePipelineOperationSerializer()
            deserializer = DeleteImagePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImagePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an image recipe.
     */
    override suspend fun deleteImageRecipe(input: DeleteImageRecipeRequest): DeleteImageRecipeResponse {
        val op = SdkHttpOperation.build<DeleteImageRecipeRequest, DeleteImageRecipeResponse> {
            serializer = DeleteImageRecipeOperationSerializer()
            deserializer = DeleteImageRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImageRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an infrastructure configuration.
     */
    override suspend fun deleteInfrastructureConfiguration(input: DeleteInfrastructureConfigurationRequest): DeleteInfrastructureConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteInfrastructureConfigurationRequest, DeleteInfrastructureConfigurationResponse> {
            serializer = DeleteInfrastructureConfigurationOperationSerializer()
            deserializer = DeleteInfrastructureConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInfrastructureConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a component object.
     */
    override suspend fun getComponent(input: GetComponentRequest): GetComponentResponse {
        val op = SdkHttpOperation.build<GetComponentRequest, GetComponentResponse> {
            serializer = GetComponentOperationSerializer()
            deserializer = GetComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a component policy.
     */
    override suspend fun getComponentPolicy(input: GetComponentPolicyRequest): GetComponentPolicyResponse {
        val op = SdkHttpOperation.build<GetComponentPolicyRequest, GetComponentPolicyResponse> {
            serializer = GetComponentPolicyOperationSerializer()
            deserializer = GetComponentPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponentPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a container recipe.
     */
    override suspend fun getContainerRecipe(input: GetContainerRecipeRequest): GetContainerRecipeResponse {
        val op = SdkHttpOperation.build<GetContainerRecipeRequest, GetContainerRecipeResponse> {
            serializer = GetContainerRecipeOperationSerializer()
            deserializer = GetContainerRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the policy for a container recipe.
     */
    override suspend fun getContainerRecipePolicy(input: GetContainerRecipePolicyRequest): GetContainerRecipePolicyResponse {
        val op = SdkHttpOperation.build<GetContainerRecipePolicyRequest, GetContainerRecipePolicyResponse> {
            serializer = GetContainerRecipePolicyOperationSerializer()
            deserializer = GetContainerRecipePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContainerRecipePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a distribution configuration.
     */
    override suspend fun getDistributionConfiguration(input: GetDistributionConfigurationRequest): GetDistributionConfigurationResponse {
        val op = SdkHttpOperation.build<GetDistributionConfigurationRequest, GetDistributionConfigurationResponse> {
            serializer = GetDistributionConfigurationOperationSerializer()
            deserializer = GetDistributionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributionConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an image.
     */
    override suspend fun getImage(input: GetImageRequest): GetImageResponse {
        val op = SdkHttpOperation.build<GetImageRequest, GetImageResponse> {
            serializer = GetImageOperationSerializer()
            deserializer = GetImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an image pipeline.
     */
    override suspend fun getImagePipeline(input: GetImagePipelineRequest): GetImagePipelineResponse {
        val op = SdkHttpOperation.build<GetImagePipelineRequest, GetImagePipelineResponse> {
            serializer = GetImagePipelineOperationSerializer()
            deserializer = GetImagePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImagePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an image policy.
     */
    override suspend fun getImagePolicy(input: GetImagePolicyRequest): GetImagePolicyResponse {
        val op = SdkHttpOperation.build<GetImagePolicyRequest, GetImagePolicyResponse> {
            serializer = GetImagePolicyOperationSerializer()
            deserializer = GetImagePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImagePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an image recipe.
     */
    override suspend fun getImageRecipe(input: GetImageRecipeRequest): GetImageRecipeResponse {
        val op = SdkHttpOperation.build<GetImageRecipeRequest, GetImageRecipeResponse> {
            serializer = GetImageRecipeOperationSerializer()
            deserializer = GetImageRecipeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImageRecipe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an image recipe policy.
     */
    override suspend fun getImageRecipePolicy(input: GetImageRecipePolicyRequest): GetImageRecipePolicyResponse {
        val op = SdkHttpOperation.build<GetImageRecipePolicyRequest, GetImageRecipePolicyResponse> {
            serializer = GetImageRecipePolicyOperationSerializer()
            deserializer = GetImageRecipePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImageRecipePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an infrastructure configuration.
     */
    override suspend fun getInfrastructureConfiguration(input: GetInfrastructureConfigurationRequest): GetInfrastructureConfigurationResponse {
        val op = SdkHttpOperation.build<GetInfrastructureConfigurationRequest, GetInfrastructureConfigurationResponse> {
            serializer = GetInfrastructureConfigurationOperationSerializer()
            deserializer = GetInfrastructureConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInfrastructureConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports a component and transforms its data into a component document.
     */
    override suspend fun importComponent(input: ImportComponentRequest): ImportComponentResponse {
        val op = SdkHttpOperation.build<ImportComponentRequest, ImportComponentResponse> {
            serializer = ImportComponentOperationSerializer()
            deserializer = ImportComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
     *
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.
     */
    override suspend fun importVmImage(input: ImportVmImageRequest): ImportVmImageResponse {
        val op = SdkHttpOperation.build<ImportVmImageRequest, ImportVmImageResponse> {
            serializer = ImportVmImageOperationSerializer()
            deserializer = ImportVmImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportVmImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of component build versions for the specified semantic version.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    override suspend fun listComponentBuildVersions(input: ListComponentBuildVersionsRequest): ListComponentBuildVersionsResponse {
        val op = SdkHttpOperation.build<ListComponentBuildVersionsRequest, ListComponentBuildVersionsResponse> {
            serializer = ListComponentBuildVersionsOperationSerializer()
            deserializer = ListComponentBuildVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponentBuildVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of component build versions for the specified semantic version.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of container recipes.
     */
    override suspend fun listContainerRecipes(input: ListContainerRecipesRequest): ListContainerRecipesResponse {
        val op = SdkHttpOperation.build<ListContainerRecipesRequest, ListContainerRecipesResponse> {
            serializer = ListContainerRecipesOperationSerializer()
            deserializer = ListContainerRecipesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContainerRecipes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of distribution configurations.
     */
    override suspend fun listDistributionConfigurations(input: ListDistributionConfigurationsRequest): ListDistributionConfigurationsResponse {
        val op = SdkHttpOperation.build<ListDistributionConfigurationsRequest, ListDistributionConfigurationsResponse> {
            serializer = ListDistributionConfigurationsOperationSerializer()
            deserializer = ListDistributionConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of image build versions.
     */
    override suspend fun listImageBuildVersions(input: ListImageBuildVersionsRequest): ListImageBuildVersionsResponse {
        val op = SdkHttpOperation.build<ListImageBuildVersionsRequest, ListImageBuildVersionsResponse> {
            serializer = ListImageBuildVersionsOperationSerializer()
            deserializer = ListImageBuildVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImageBuildVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
     */
    override suspend fun listImagePackages(input: ListImagePackagesRequest): ListImagePackagesResponse {
        val op = SdkHttpOperation.build<ListImagePackagesRequest, ListImagePackagesResponse> {
            serializer = ListImagePackagesOperationSerializer()
            deserializer = ListImagePackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImagePackages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of images created by the specified pipeline.
     */
    override suspend fun listImagePipelineImages(input: ListImagePipelineImagesRequest): ListImagePipelineImagesResponse {
        val op = SdkHttpOperation.build<ListImagePipelineImagesRequest, ListImagePipelineImagesResponse> {
            serializer = ListImagePipelineImagesOperationSerializer()
            deserializer = ListImagePipelineImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImagePipelineImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of image pipelines.
     */
    override suspend fun listImagePipelines(input: ListImagePipelinesRequest): ListImagePipelinesResponse {
        val op = SdkHttpOperation.build<ListImagePipelinesRequest, ListImagePipelinesResponse> {
            serializer = ListImagePipelinesOperationSerializer()
            deserializer = ListImagePipelinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImagePipelines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of image recipes.
     */
    override suspend fun listImageRecipes(input: ListImageRecipesRequest): ListImageRecipesResponse {
        val op = SdkHttpOperation.build<ListImageRecipesRequest, ListImageRecipesResponse> {
            serializer = ListImageRecipesOperationSerializer()
            deserializer = ListImageRecipesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImageRecipes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of images that you have access to.
     */
    override suspend fun listImages(input: ListImagesRequest): ListImagesResponse {
        val op = SdkHttpOperation.build<ListImagesRequest, ListImagesResponse> {
            serializer = ListImagesOperationSerializer()
            deserializer = ListImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of infrastructure configurations.
     */
    override suspend fun listInfrastructureConfigurations(input: ListInfrastructureConfigurationsRequest): ListInfrastructureConfigurationsResponse {
        val op = SdkHttpOperation.build<ListInfrastructureConfigurationsRequest, ListInfrastructureConfigurationsResponse> {
            serializer = ListInfrastructureConfigurationsOperationSerializer()
            deserializer = ListInfrastructureConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInfrastructureConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutComponentPolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    override suspend fun putComponentPolicy(input: PutComponentPolicyRequest): PutComponentPolicyResponse {
        val op = SdkHttpOperation.build<PutComponentPolicyRequest, PutComponentPolicyResponse> {
            serializer = PutComponentPolicyOperationSerializer()
            deserializer = PutComponentPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutComponentPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    override suspend fun putContainerRecipePolicy(input: PutContainerRecipePolicyRequest): PutContainerRecipePolicyResponse {
        val op = SdkHttpOperation.build<PutContainerRecipePolicyRequest, PutContainerRecipePolicyResponse> {
            serializer = PutContainerRecipePolicyOperationSerializer()
            deserializer = PutContainerRecipePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutContainerRecipePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImagePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    override suspend fun putImagePolicy(input: PutImagePolicyRequest): PutImagePolicyResponse {
        val op = SdkHttpOperation.build<PutImagePolicyRequest, PutImagePolicyResponse> {
            serializer = PutImagePolicyOperationSerializer()
            deserializer = PutImagePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutImagePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImageRecipePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    override suspend fun putImageRecipePolicy(input: PutImageRecipePolicyRequest): PutImageRecipePolicyResponse {
        val op = SdkHttpOperation.build<PutImageRecipePolicyRequest, PutImageRecipePolicyResponse> {
            serializer = PutImageRecipePolicyOperationSerializer()
            deserializer = PutImageRecipePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutImageRecipePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Manually triggers a pipeline to create an image.
     */
    override suspend fun startImagePipelineExecution(input: StartImagePipelineExecutionRequest): StartImagePipelineExecutionResponse {
        val op = SdkHttpOperation.build<StartImagePipelineExecutionRequest, StartImagePipelineExecutionResponse> {
            serializer = StartImagePipelineExecutionOperationSerializer()
            deserializer = StartImagePipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartImagePipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    override suspend fun updateDistributionConfiguration(input: UpdateDistributionConfigurationRequest): UpdateDistributionConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateDistributionConfigurationRequest, UpdateDistributionConfigurationResponse> {
            serializer = UpdateDistributionConfigurationOperationSerializer()
            deserializer = UpdateDistributionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDistributionConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     *
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.
     */
    override suspend fun updateImagePipeline(input: UpdateImagePipelineRequest): UpdateImagePipelineResponse {
        val op = SdkHttpOperation.build<UpdateImagePipelineRequest, UpdateImagePipelineResponse> {
            serializer = UpdateImagePipelineOperationSerializer()
            deserializer = UpdateImagePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateImagePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    override suspend fun updateInfrastructureConfiguration(input: UpdateInfrastructureConfigurationRequest): UpdateInfrastructureConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateInfrastructureConfigurationRequest, UpdateInfrastructureConfigurationResponse> {
            serializer = UpdateInfrastructureConfigurationOperationSerializer()
            deserializer = UpdateInfrastructureConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInfrastructureConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "imagebuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "imagebuilder")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
