// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.imagebuilder.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.imagebuilder.model.*
import aws.sdk.kotlin.services.imagebuilder.model.CancelImageCreationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CancelImageCreationResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.CreateInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentPolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentPolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImagePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipeRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.GetInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.GetInfrastructureConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest
import aws.sdk.kotlin.services.imagebuilder.model.ImportComponentResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageRequest
import aws.sdk.kotlin.services.imagebuilder.model.ImportVmImageResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutComponentPolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutComponentPolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutContainerRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutContainerRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutImagePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutImagePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.PutImageRecipePolicyRequest
import aws.sdk.kotlin.services.imagebuilder.model.PutImageRecipePolicyResponse
import aws.sdk.kotlin.services.imagebuilder.model.StartImagePipelineExecutionRequest
import aws.sdk.kotlin.services.imagebuilder.model.StartImagePipelineExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.TagResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.TagResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.UntagResourceRequest
import aws.sdk.kotlin.services.imagebuilder.model.UntagResourceResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateDistributionConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateDistributionConfigurationResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateImagePipelineRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateImagePipelineResponse
import aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
import aws.sdk.kotlin.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the creation, management, and deployment of customized, secure, and up-to-date "golden" server images that are pre-installed and pre-configured with software and settings to meet specific IT standards.
 */
public interface ImagebuilderClient : SdkClient {

    override val serviceName: String
        get() = "imagebuilder"
    /**
     * ImagebuilderClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ImagebuilderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultImagebuilderClient(config)
        }

        public operator fun invoke(config: Config): ImagebuilderClient = DefaultImagebuilderClient(config)

        /**
         * Construct a [ImagebuilderClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ImagebuilderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultImagebuilderClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
     */
    public suspend fun cancelImageCreation(input: CancelImageCreationRequest): CancelImageCreationResponse

    /**
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
     * + Inline, using the `data` property in the request body.
     * + A URL that points to a YAML document file stored in Amazon S3, using the `uri` property in the request body.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     */
    public suspend fun createContainerRecipe(input: CreateContainerRecipeRequest): CreateContainerRecipeResponse

    /**
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    public suspend fun createDistributionConfiguration(input: CreateDistributionConfigurationRequest): CreateDistributionConfigurationResponse

    /**
     * Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
     */
    public suspend fun createImage(input: CreateImageRequest): CreateImageResponse

    /**
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     */
    public suspend fun createImagePipeline(input: CreateImagePipelineRequest): CreateImagePipelineResponse

    /**
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     */
    public suspend fun createImageRecipe(input: CreateImageRecipeRequest): CreateImageRecipeResponse

    /**
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    public suspend fun createInfrastructureConfiguration(input: CreateInfrastructureConfigurationRequest): CreateInfrastructureConfigurationResponse

    /**
     * Deletes a component build version.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a container recipe.
     */
    public suspend fun deleteContainerRecipe(input: DeleteContainerRecipeRequest): DeleteContainerRecipeResponse

    /**
     * Deletes a distribution configuration.
     */
    public suspend fun deleteDistributionConfiguration(input: DeleteDistributionConfigurationRequest): DeleteDistributionConfigurationResponse

    /**
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
     * + To deregister an EC2 Linux AMI, see [Deregister your Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html) in the **Amazon EC2 User Guide**.
     * + To deregister an EC2 Windows AMI, see [Deregister your Windows AMI](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html) in the **Amazon EC2 Windows Guide**.
     * + To delete a container image from Amazon ECR, see [Deleting an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html) in the *Amazon ECR User Guide*.
     */
    public suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse

    /**
     * Deletes an image pipeline.
     */
    public suspend fun deleteImagePipeline(input: DeleteImagePipelineRequest): DeleteImagePipelineResponse

    /**
     * Deletes an image recipe.
     */
    public suspend fun deleteImageRecipe(input: DeleteImageRecipeRequest): DeleteImageRecipeResponse

    /**
     * Deletes an infrastructure configuration.
     */
    public suspend fun deleteInfrastructureConfiguration(input: DeleteInfrastructureConfigurationRequest): DeleteInfrastructureConfigurationResponse

    /**
     * Gets a component object.
     */
    public suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Gets a component policy.
     */
    public suspend fun getComponentPolicy(input: GetComponentPolicyRequest): GetComponentPolicyResponse

    /**
     * Retrieves a container recipe.
     */
    public suspend fun getContainerRecipe(input: GetContainerRecipeRequest): GetContainerRecipeResponse

    /**
     * Retrieves the policy for a container recipe.
     */
    public suspend fun getContainerRecipePolicy(input: GetContainerRecipePolicyRequest): GetContainerRecipePolicyResponse

    /**
     * Gets a distribution configuration.
     */
    public suspend fun getDistributionConfiguration(input: GetDistributionConfigurationRequest): GetDistributionConfigurationResponse

    /**
     * Gets an image.
     */
    public suspend fun getImage(input: GetImageRequest): GetImageResponse

    /**
     * Gets an image pipeline.
     */
    public suspend fun getImagePipeline(input: GetImagePipelineRequest): GetImagePipelineResponse

    /**
     * Gets an image policy.
     */
    public suspend fun getImagePolicy(input: GetImagePolicyRequest): GetImagePolicyResponse

    /**
     * Gets an image recipe.
     */
    public suspend fun getImageRecipe(input: GetImageRecipeRequest): GetImageRecipeResponse

    /**
     * Gets an image recipe policy.
     */
    public suspend fun getImageRecipePolicy(input: GetImageRecipePolicyRequest): GetImageRecipePolicyResponse

    /**
     * Gets an infrastructure configuration.
     */
    public suspend fun getInfrastructureConfiguration(input: GetInfrastructureConfigurationRequest): GetInfrastructureConfigurationResponse

    /**
     * Imports a component and transforms its data into a component document.
     */
    public suspend fun importComponent(input: ImportComponentRequest): ImportComponentResponse

    /**
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
     *
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.
     */
    public suspend fun importVmImage(input: ImportVmImageRequest): ImportVmImageResponse

    /**
     * Returns the list of component build versions for the specified semantic version.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public suspend fun listComponentBuildVersions(input: ListComponentBuildVersionsRequest): ListComponentBuildVersionsResponse

    /**
     * Returns the list of component build versions for the specified semantic version.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public suspend fun listComponents(input: ListComponentsRequest = ListComponentsRequest {}): ListComponentsResponse

    /**
     * Returns a list of container recipes.
     */
    public suspend fun listContainerRecipes(input: ListContainerRecipesRequest = ListContainerRecipesRequest {}): ListContainerRecipesResponse

    /**
     * Returns a list of distribution configurations.
     */
    public suspend fun listDistributionConfigurations(input: ListDistributionConfigurationsRequest = ListDistributionConfigurationsRequest {}): ListDistributionConfigurationsResponse

    /**
     * Returns a list of image build versions.
     */
    public suspend fun listImageBuildVersions(input: ListImageBuildVersionsRequest): ListImageBuildVersionsResponse

    /**
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
     */
    public suspend fun listImagePackages(input: ListImagePackagesRequest): ListImagePackagesResponse

    /**
     * Returns a list of images created by the specified pipeline.
     */
    public suspend fun listImagePipelineImages(input: ListImagePipelineImagesRequest): ListImagePipelineImagesResponse

    /**
     * Returns a list of image pipelines.
     */
    public suspend fun listImagePipelines(input: ListImagePipelinesRequest = ListImagePipelinesRequest {}): ListImagePipelinesResponse

    /**
     * Returns a list of image recipes.
     */
    public suspend fun listImageRecipes(input: ListImageRecipesRequest = ListImageRecipesRequest {}): ListImageRecipesResponse

    /**
     * Returns the list of images that you have access to.
     */
    public suspend fun listImages(input: ListImagesRequest = ListImagesRequest {}): ListImagesResponse

    /**
     * Returns a list of infrastructure configurations.
     */
    public suspend fun listInfrastructureConfigurations(input: ListInfrastructureConfigurationsRequest = ListInfrastructureConfigurationsRequest {}): ListInfrastructureConfigurationsResponse

    /**
     * Returns the list of tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutComponentPolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putComponentPolicy(input: PutComponentPolicyRequest): PutComponentPolicyResponse

    /**
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putContainerRecipePolicy(input: PutContainerRecipePolicyRequest): PutContainerRecipePolicyResponse

    /**
     * Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImagePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putImagePolicy(input: PutImagePolicyRequest): PutImagePolicyResponse

    /**
     * Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImageRecipePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    public suspend fun putImageRecipePolicy(input: PutImageRecipePolicyRequest): PutImageRecipePolicyResponse

    /**
     * Manually triggers a pipeline to create an image.
     */
    public suspend fun startImagePipelineExecution(input: StartImagePipelineExecutionRequest): StartImagePipelineExecutionResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
     */
    public suspend fun updateDistributionConfiguration(input: UpdateDistributionConfigurationRequest): UpdateDistributionConfigurationResponse

    /**
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     *
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.
     */
    public suspend fun updateImagePipeline(input: UpdateImagePipelineRequest): UpdateImagePipelineResponse

    /**
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
     */
    public suspend fun updateInfrastructureConfiguration(input: UpdateInfrastructureConfigurationRequest): UpdateInfrastructureConfigurationResponse
}

/**
 * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.
 */
public suspend inline fun ImagebuilderClient.cancelImageCreation(crossinline block: CancelImageCreationRequest.Builder.() -> Unit): CancelImageCreationResponse = cancelImageCreation(CancelImageCreationRequest.Builder().apply(block).build())

/**
 * Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:
 * + Inline, using the `data` property in the request body.
 * + A URL that points to a YAML document file stored in Amazon S3, using the `uri` property in the request body.
 */
public suspend inline fun ImagebuilderClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
 */
public suspend inline fun ImagebuilderClient.createContainerRecipe(crossinline block: CreateContainerRecipeRequest.Builder.() -> Unit): CreateContainerRecipeResponse = createContainerRecipe(CreateContainerRecipeRequest.Builder().apply(block).build())

/**
 * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
 */
public suspend inline fun ImagebuilderClient.createDistributionConfiguration(crossinline block: CreateDistributionConfigurationRequest.Builder.() -> Unit): CreateDistributionConfigurationResponse = createDistributionConfiguration(CreateDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
 */
public suspend inline fun ImagebuilderClient.createImage(crossinline block: CreateImageRequest.Builder.() -> Unit): CreateImageResponse = createImage(CreateImageRequest.Builder().apply(block).build())

/**
 * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
 */
public suspend inline fun ImagebuilderClient.createImagePipeline(crossinline block: CreateImagePipelineRequest.Builder.() -> Unit): CreateImagePipelineResponse = createImagePipeline(CreateImagePipelineRequest.Builder().apply(block).build())

/**
 * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
 */
public suspend inline fun ImagebuilderClient.createImageRecipe(crossinline block: CreateImageRecipeRequest.Builder.() -> Unit): CreateImageRecipeResponse = createImageRecipe(CreateImageRecipeRequest.Builder().apply(block).build())

/**
 * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
 */
public suspend inline fun ImagebuilderClient.createInfrastructureConfiguration(crossinline block: CreateInfrastructureConfigurationRequest.Builder.() -> Unit): CreateInfrastructureConfigurationResponse = createInfrastructureConfiguration(CreateInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a component build version.
 */
public suspend inline fun ImagebuilderClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Deletes a container recipe.
 */
public suspend inline fun ImagebuilderClient.deleteContainerRecipe(crossinline block: DeleteContainerRecipeRequest.Builder.() -> Unit): DeleteContainerRecipeResponse = deleteContainerRecipe(DeleteContainerRecipeRequest.Builder().apply(block).build())

/**
 * Deletes a distribution configuration.
 */
public suspend inline fun ImagebuilderClient.deleteDistributionConfiguration(crossinline block: DeleteDistributionConfigurationRequest.Builder.() -> Unit): DeleteDistributionConfigurationResponse = deleteDistributionConfiguration(DeleteDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.
 * + To deregister an EC2 Linux AMI, see [Deregister your Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html) in the **Amazon EC2 User Guide**.
 * + To deregister an EC2 Windows AMI, see [Deregister your Windows AMI](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html) in the **Amazon EC2 Windows Guide**.
 * + To delete a container image from Amazon ECR, see [Deleting an image](https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html) in the *Amazon ECR User Guide*.
 */
public suspend inline fun ImagebuilderClient.deleteImage(crossinline block: DeleteImageRequest.Builder.() -> Unit): DeleteImageResponse = deleteImage(DeleteImageRequest.Builder().apply(block).build())

/**
 * Deletes an image pipeline.
 */
public suspend inline fun ImagebuilderClient.deleteImagePipeline(crossinline block: DeleteImagePipelineRequest.Builder.() -> Unit): DeleteImagePipelineResponse = deleteImagePipeline(DeleteImagePipelineRequest.Builder().apply(block).build())

/**
 * Deletes an image recipe.
 */
public suspend inline fun ImagebuilderClient.deleteImageRecipe(crossinline block: DeleteImageRecipeRequest.Builder.() -> Unit): DeleteImageRecipeResponse = deleteImageRecipe(DeleteImageRecipeRequest.Builder().apply(block).build())

/**
 * Deletes an infrastructure configuration.
 */
public suspend inline fun ImagebuilderClient.deleteInfrastructureConfiguration(crossinline block: DeleteInfrastructureConfigurationRequest.Builder.() -> Unit): DeleteInfrastructureConfigurationResponse = deleteInfrastructureConfiguration(DeleteInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Gets a component object.
 */
public suspend inline fun ImagebuilderClient.getComponent(crossinline block: GetComponentRequest.Builder.() -> Unit): GetComponentResponse = getComponent(GetComponentRequest.Builder().apply(block).build())

/**
 * Gets a component policy.
 */
public suspend inline fun ImagebuilderClient.getComponentPolicy(crossinline block: GetComponentPolicyRequest.Builder.() -> Unit): GetComponentPolicyResponse = getComponentPolicy(GetComponentPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves a container recipe.
 */
public suspend inline fun ImagebuilderClient.getContainerRecipe(crossinline block: GetContainerRecipeRequest.Builder.() -> Unit): GetContainerRecipeResponse = getContainerRecipe(GetContainerRecipeRequest.Builder().apply(block).build())

/**
 * Retrieves the policy for a container recipe.
 */
public suspend inline fun ImagebuilderClient.getContainerRecipePolicy(crossinline block: GetContainerRecipePolicyRequest.Builder.() -> Unit): GetContainerRecipePolicyResponse = getContainerRecipePolicy(GetContainerRecipePolicyRequest.Builder().apply(block).build())

/**
 * Gets a distribution configuration.
 */
public suspend inline fun ImagebuilderClient.getDistributionConfiguration(crossinline block: GetDistributionConfigurationRequest.Builder.() -> Unit): GetDistributionConfigurationResponse = getDistributionConfiguration(GetDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Gets an image.
 */
public suspend inline fun ImagebuilderClient.getImage(crossinline block: GetImageRequest.Builder.() -> Unit): GetImageResponse = getImage(GetImageRequest.Builder().apply(block).build())

/**
 * Gets an image pipeline.
 */
public suspend inline fun ImagebuilderClient.getImagePipeline(crossinline block: GetImagePipelineRequest.Builder.() -> Unit): GetImagePipelineResponse = getImagePipeline(GetImagePipelineRequest.Builder().apply(block).build())

/**
 * Gets an image policy.
 */
public suspend inline fun ImagebuilderClient.getImagePolicy(crossinline block: GetImagePolicyRequest.Builder.() -> Unit): GetImagePolicyResponse = getImagePolicy(GetImagePolicyRequest.Builder().apply(block).build())

/**
 * Gets an image recipe.
 */
public suspend inline fun ImagebuilderClient.getImageRecipe(crossinline block: GetImageRecipeRequest.Builder.() -> Unit): GetImageRecipeResponse = getImageRecipe(GetImageRecipeRequest.Builder().apply(block).build())

/**
 * Gets an image recipe policy.
 */
public suspend inline fun ImagebuilderClient.getImageRecipePolicy(crossinline block: GetImageRecipePolicyRequest.Builder.() -> Unit): GetImageRecipePolicyResponse = getImageRecipePolicy(GetImageRecipePolicyRequest.Builder().apply(block).build())

/**
 * Gets an infrastructure configuration.
 */
public suspend inline fun ImagebuilderClient.getInfrastructureConfiguration(crossinline block: GetInfrastructureConfigurationRequest.Builder.() -> Unit): GetInfrastructureConfigurationResponse = getInfrastructureConfiguration(GetInfrastructureConfigurationRequest.Builder().apply(block).build())

/**
 * Imports a component and transforms its data into a component document.
 */
public suspend inline fun ImagebuilderClient.importComponent(crossinline block: ImportComponentRequest.Builder.() -> Unit): ImportComponentResponse = importComponent(ImportComponentRequest.Builder().apply(block).build())

/**
 * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API [ImportImage](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html) action uses those files to import your VM and create an AMI. To import using the CLI command, see [import-image](https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
 *
 * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.
 */
public suspend inline fun ImagebuilderClient.importVmImage(crossinline block: ImportVmImageRequest.Builder.() -> Unit): ImportVmImageResponse = importVmImage(ImportVmImageRequest.Builder().apply(block).build())

/**
 * Returns the list of component build versions for the specified semantic version.
 *
 * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
 *
 * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
 */
public suspend inline fun ImagebuilderClient.listComponentBuildVersions(crossinline block: ListComponentBuildVersionsRequest.Builder.() -> Unit): ListComponentBuildVersionsResponse = listComponentBuildVersions(ListComponentBuildVersionsRequest.Builder().apply(block).build())

/**
 * Returns the list of component build versions for the specified semantic version.
 *
 * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
 *
 * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
 */
public suspend inline fun ImagebuilderClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Returns a list of container recipes.
 */
public suspend inline fun ImagebuilderClient.listContainerRecipes(crossinline block: ListContainerRecipesRequest.Builder.() -> Unit): ListContainerRecipesResponse = listContainerRecipes(ListContainerRecipesRequest.Builder().apply(block).build())

/**
 * Returns a list of distribution configurations.
 */
public suspend inline fun ImagebuilderClient.listDistributionConfigurations(crossinline block: ListDistributionConfigurationsRequest.Builder.() -> Unit): ListDistributionConfigurationsResponse = listDistributionConfigurations(ListDistributionConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of image build versions.
 */
public suspend inline fun ImagebuilderClient.listImageBuildVersions(crossinline block: ListImageBuildVersionsRequest.Builder.() -> Unit): ListImageBuildVersionsResponse = listImageBuildVersions(ListImageBuildVersionsRequest.Builder().apply(block).build())

/**
 * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.
 */
public suspend inline fun ImagebuilderClient.listImagePackages(crossinline block: ListImagePackagesRequest.Builder.() -> Unit): ListImagePackagesResponse = listImagePackages(ListImagePackagesRequest.Builder().apply(block).build())

/**
 * Returns a list of images created by the specified pipeline.
 */
public suspend inline fun ImagebuilderClient.listImagePipelineImages(crossinline block: ListImagePipelineImagesRequest.Builder.() -> Unit): ListImagePipelineImagesResponse = listImagePipelineImages(ListImagePipelineImagesRequest.Builder().apply(block).build())

/**
 * Returns a list of image pipelines.
 */
public suspend inline fun ImagebuilderClient.listImagePipelines(crossinline block: ListImagePipelinesRequest.Builder.() -> Unit): ListImagePipelinesResponse = listImagePipelines(ListImagePipelinesRequest.Builder().apply(block).build())

/**
 * Returns a list of image recipes.
 */
public suspend inline fun ImagebuilderClient.listImageRecipes(crossinline block: ListImageRecipesRequest.Builder.() -> Unit): ListImageRecipesResponse = listImageRecipes(ListImageRecipesRequest.Builder().apply(block).build())

/**
 * Returns the list of images that you have access to.
 */
public suspend inline fun ImagebuilderClient.listImages(crossinline block: ListImagesRequest.Builder.() -> Unit): ListImagesResponse = listImages(ListImagesRequest.Builder().apply(block).build())

/**
 * Returns a list of infrastructure configurations.
 */
public suspend inline fun ImagebuilderClient.listInfrastructureConfigurations(crossinline block: ListInfrastructureConfigurationsRequest.Builder.() -> Unit): ListInfrastructureConfigurationsResponse = listInfrastructureConfigurations(ListInfrastructureConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns the list of tags for the specified resource.
 */
public suspend inline fun ImagebuilderClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Applies a policy to a component. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutComponentPolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putComponentPolicy(crossinline block: PutComponentPolicyRequest.Builder.() -> Unit): PutComponentPolicyResponse = putComponentPolicy(PutComponentPolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutContainerImagePolicy`, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putContainerRecipePolicy(crossinline block: PutContainerRecipePolicyRequest.Builder.() -> Unit): PutContainerRecipePolicyResponse = putContainerRecipePolicy(PutContainerRecipePolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to an image. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImagePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putImagePolicy(crossinline block: PutImagePolicyRequest.Builder.() -> Unit): PutImagePolicyResponse = putImagePolicy(PutImagePolicyRequest.Builder().apply(block).build())

/**
 * Applies a policy to an image recipe. We recommend that you call the RAM API [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API `PutImageRecipePolicy`, you must also call the RAM API [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
 */
public suspend inline fun ImagebuilderClient.putImageRecipePolicy(crossinline block: PutImageRecipePolicyRequest.Builder.() -> Unit): PutImageRecipePolicyResponse = putImageRecipePolicy(PutImageRecipePolicyRequest.Builder().apply(block).build())

/**
 * Manually triggers a pipeline to create an image.
 */
public suspend inline fun ImagebuilderClient.startImagePipelineExecution(crossinline block: StartImagePipelineExecutionRequest.Builder.() -> Unit): StartImagePipelineExecutionResponse = startImagePipelineExecution(StartImagePipelineExecutionRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun ImagebuilderClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun ImagebuilderClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.
 */
public suspend inline fun ImagebuilderClient.updateDistributionConfiguration(crossinline block: UpdateDistributionConfigurationRequest.Builder.() -> Unit): UpdateDistributionConfigurationResponse = updateDistributionConfiguration(UpdateDistributionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.
 *
 * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.
 */
public suspend inline fun ImagebuilderClient.updateImagePipeline(crossinline block: UpdateImagePipelineRequest.Builder.() -> Unit): UpdateImagePipelineResponse = updateImagePipeline(UpdateImagePipelineRequest.Builder().apply(block).build())

/**
 * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.
 */
public suspend inline fun ImagebuilderClient.updateInfrastructureConfiguration(crossinline block: UpdateInfrastructureConfigurationRequest.Builder.() -> Unit): UpdateInfrastructureConfigurationResponse = updateInfrastructureConfiguration(UpdateInfrastructureConfigurationRequest.Builder().apply(block).build())
