// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Define and configure the output AMIs of the pipeline.
 */
public class AmiDistributionConfiguration private constructor(builder: Builder) {
    /**
     * The tags to apply to AMIs distributed to this Region.
     */
    public val amiTags: Map<String, String>? = builder.amiTags
    /**
     * The description of the AMI distribution configuration. Minimum and maximum length are in characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The KMS key identifier used to encrypt the distributed image.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch instances.
     */
    public val launchPermission: aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration? = builder.launchPermission
    /**
     * The name of the output AMI.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of an account to which you want to distribute an image.
     */
    public val targetAccountIds: List<String>? = builder.targetAccountIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AmiDistributionConfiguration(")
        append("amiTags=$amiTags,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("launchPermission=$launchPermission,")
        append("name=$name,")
        append("targetAccountIds=$targetAccountIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiTags?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (launchPermission?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (targetAccountIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AmiDistributionConfiguration

        if (amiTags != other.amiTags) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (launchPermission != other.launchPermission) return false
        if (name != other.name) return false
        if (targetAccountIds != other.targetAccountIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The tags to apply to AMIs distributed to this Region.
         */
        public var amiTags: Map<String, String>? = null
        /**
         * The description of the AMI distribution configuration. Minimum and maximum length are in characters.
         */
        public var description: kotlin.String? = null
        /**
         * The KMS key identifier used to encrypt the distributed image.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch instances.
         */
        public var launchPermission: aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration? = null
        /**
         * The name of the output AMI.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of an account to which you want to distribute an image.
         */
        public var targetAccountIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration) : this() {
            this.amiTags = x.amiTags
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.launchPermission = x.launchPermission
            this.name = x.name
            this.targetAccountIds = x.targetAccountIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.AmiDistributionConfiguration = AmiDistributionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration] inside the given [block]
         */
        public fun launchPermission(block: aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration.Builder.() -> kotlin.Unit) {
            this.launchPermission = aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration.invoke(block)
        }
    }
}
