// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An Image Builder image. You must specify exactly one recipe for the image – either a container recipe (`containerRecipe`), which creates a container image, or an image recipe (`imageRecipe`), which creates an AMI.
 */
public class Image private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the image.
     *
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
     * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Indicates the type of build that created this image. The build can be initiated in the following ways:
     * + **USER_INITIATED** – A manual pipeline build request.
     * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
     * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
     */
    public val buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = builder.buildType
    /**
     * The recipe that is used to create an Image Builder container image.
     */
    public val containerRecipe: aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe? = builder.containerRecipe
    /**
     * The date on which this image was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The distribution configuration used when creating this image.
     */
    public val distributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration? = builder.distributionConfiguration
    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    public val enhancedImageMetadataEnabled: kotlin.Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The image recipe used when creating the image.
     */
    public val imageRecipe: aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe? = builder.imageRecipe
    /**
     * The image tests configuration used when creating this image.
     */
    public val imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The infrastructure used when creating this image.
     */
    public val infrastructureConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration? = builder.infrastructureConfiguration
    /**
     * The name of the image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The output resources produced when creating this image.
     */
    public val outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = builder.outputResources
    /**
     * The platform of the image.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The Amazon Resource Name (ARN) of the image pipeline that created this image.
     */
    public val sourcePipelineArn: kotlin.String? = builder.sourcePipelineArn
    /**
     * The name of the image pipeline that created this image.
     */
    public val sourcePipelineName: kotlin.String? = builder.sourcePipelineName
    /**
     * The state of the image.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = builder.state
    /**
     * The tags of the image.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether this is an AMI or container image.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = builder.type
    /**
     * The semantic version of the image.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Image = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("arn=$arn,")
        append("buildType=$buildType,")
        append("containerRecipe=$containerRecipe,")
        append("dateCreated=$dateCreated,")
        append("distributionConfiguration=$distributionConfiguration,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipe=$imageRecipe,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfiguration=$infrastructureConfiguration,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("outputResources=$outputResources,")
        append("platform=$platform,")
        append("sourcePipelineArn=$sourcePipelineArn,")
        append("sourcePipelineName=$sourcePipelineName,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (buildType?.hashCode() ?: 0)
        result = 31 * result + (containerRecipe?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (distributionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipe?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (outputResources?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (sourcePipelineArn?.hashCode() ?: 0)
        result = 31 * result + (sourcePipelineName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Image

        if (arn != other.arn) return false
        if (buildType != other.buildType) return false
        if (containerRecipe != other.containerRecipe) return false
        if (dateCreated != other.dateCreated) return false
        if (distributionConfiguration != other.distributionConfiguration) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipe != other.imageRecipe) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfiguration != other.infrastructureConfiguration) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (outputResources != other.outputResources) return false
        if (platform != other.platform) return false
        if (sourcePipelineArn != other.sourcePipelineArn) return false
        if (sourcePipelineName != other.sourcePipelineName) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Image = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the image.
         *
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
         * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         */
        public var arn: kotlin.String? = null
        /**
         * Indicates the type of build that created this image. The build can be initiated in the following ways:
         * + **USER_INITIATED** – A manual pipeline build request.
         * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
         * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
         */
        public var buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = null
        /**
         * The recipe that is used to create an Image Builder container image.
         */
        public var containerRecipe: aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe? = null
        /**
         * The date on which this image was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The distribution configuration used when creating this image.
         */
        public var distributionConfiguration: aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration? = null
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         */
        public var enhancedImageMetadataEnabled: kotlin.Boolean? = null
        /**
         * The image recipe used when creating the image.
         */
        public var imageRecipe: aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe? = null
        /**
         * The image tests configuration used when creating this image.
         */
        public var imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = null
        /**
         * The infrastructure used when creating this image.
         */
        public var infrastructureConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration? = null
        /**
         * The name of the image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The output resources produced when creating this image.
         */
        public var outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = null
        /**
         * The platform of the image.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that created this image.
         */
        public var sourcePipelineArn: kotlin.String? = null
        /**
         * The name of the image pipeline that created this image.
         */
        public var sourcePipelineName: kotlin.String? = null
        /**
         * The state of the image.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = null
        /**
         * The tags of the image.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies whether this is an AMI or container image.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = null
        /**
         * The semantic version of the image.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         *
         * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Image) : this() {
            this.arn = x.arn
            this.buildType = x.buildType
            this.containerRecipe = x.containerRecipe
            this.dateCreated = x.dateCreated
            this.distributionConfiguration = x.distributionConfiguration
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipe = x.imageRecipe
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfiguration = x.infrastructureConfiguration
            this.name = x.name
            this.osVersion = x.osVersion
            this.outputResources = x.outputResources
            this.platform = x.platform
            this.sourcePipelineArn = x.sourcePipelineArn
            this.sourcePipelineName = x.sourcePipelineName
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Image = Image(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe] inside the given [block]
         */
        public fun containerRecipe(block: aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe.Builder.() -> kotlin.Unit) {
            this.containerRecipe = aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration] inside the given [block]
         */
        public fun distributionConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration.Builder.() -> kotlin.Unit) {
            this.distributionConfiguration = aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe] inside the given [block]
         */
        public fun imageRecipe(block: aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe.Builder.() -> kotlin.Unit) {
            this.imageRecipe = aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        public fun imageTestsConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.Builder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration] inside the given [block]
         */
        public fun infrastructureConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration.Builder.() -> kotlin.Unit) {
            this.infrastructureConfiguration = aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.OutputResources] inside the given [block]
         */
        public fun outputResources(block: aws.sdk.kotlin.services.imagebuilder.model.OutputResources.Builder.() -> kotlin.Unit) {
            this.outputResources = aws.sdk.kotlin.services.imagebuilder.model.OutputResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.ImageState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.ImageState.invoke(block)
        }
    }
}
