// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An image recipe.
 */
public class ImageRecipe private constructor(builder: Builder) {
    /**
     * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration. Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.
     */
    public val additionalInstanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration? = builder.additionalInstanceConfiguration
    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The block device mappings to apply when creating images from this recipe.
     */
    public val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The components of the image recipe.
     */
    public val components: List<ComponentConfiguration>? = builder.components
    /**
     * The date on which this image recipe was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The description of the image recipe.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the image recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the image recipe.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The base image of the image recipe.
     */
    public val parentImage: kotlin.String? = builder.parentImage
    /**
     * The platform of the image recipe.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The tags of the image recipe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies which type of image is created by the recipe - an AMI or a container image.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = builder.type
    /**
     * The version of the image recipe.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The working directory to be used during build and test workflows.
     */
    public val workingDirectory: kotlin.String? = builder.workingDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageRecipe(")
        append("additionalInstanceConfiguration=$additionalInstanceConfiguration,")
        append("arn=$arn,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("components=$components,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInstanceConfiguration?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageRecipe

        if (additionalInstanceConfiguration != other.additionalInstanceConfiguration) return false
        if (arn != other.arn) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (components != other.components) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration. Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.
         */
        public var additionalInstanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         */
        public var arn: kotlin.String? = null
        /**
         * The block device mappings to apply when creating images from this recipe.
         */
        public var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        /**
         * The components of the image recipe.
         */
        public var components: List<ComponentConfiguration>? = null
        /**
         * The date on which this image recipe was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The description of the image recipe.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the image recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the image recipe.
         */
        public var owner: kotlin.String? = null
        /**
         * The base image of the image recipe.
         */
        public var parentImage: kotlin.String? = null
        /**
         * The platform of the image recipe.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The tags of the image recipe.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies which type of image is created by the recipe - an AMI or a container image.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = null
        /**
         * The version of the image recipe.
         */
        public var version: kotlin.String? = null
        /**
         * The working directory to be used during build and test workflows.
         */
        public var workingDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe) : this() {
            this.additionalInstanceConfiguration = x.additionalInstanceConfiguration
            this.arn = x.arn
            this.blockDeviceMappings = x.blockDeviceMappings
            this.components = x.components
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe = ImageRecipe(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration] inside the given [block]
         */
        public fun additionalInstanceConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.additionalInstanceConfiguration = aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration.invoke(block)
        }
    }
}
