// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An image summary.
 */
public class ImageSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the image.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Indicates the type of build that created this image. The build can be initiated in the following ways:
     * + **USER_INITIATED** – A manual pipeline build request.
     * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
     * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
     */
    public val buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = builder.buildType
    /**
     * The date on which this image was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The name of the image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The output resources produced when creating this image.
     */
    public val outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = builder.outputResources
    /**
     * The owner of the image.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The platform of the image.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The state of the image.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = builder.state
    /**
     * The tags of the image.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether this is an AMI or container image.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = builder.type
    /**
     * The version of the image.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageSummary(")
        append("arn=$arn,")
        append("buildType=$buildType,")
        append("dateCreated=$dateCreated,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("outputResources=$outputResources,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (buildType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (outputResources?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageSummary

        if (arn != other.arn) return false
        if (buildType != other.buildType) return false
        if (dateCreated != other.dateCreated) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (outputResources != other.outputResources) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the image.
         */
        public var arn: kotlin.String? = null
        /**
         * Indicates the type of build that created this image. The build can be initiated in the following ways:
         * + **USER_INITIATED** – A manual pipeline build request.
         * + **SCHEDULED** – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.
         * + **IMPORT** – A VM import created the image to use as the base image for the recipe.
         */
        public var buildType: aws.sdk.kotlin.services.imagebuilder.model.BuildType? = null
        /**
         * The date on which this image was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The name of the image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The output resources produced when creating this image.
         */
        public var outputResources: aws.sdk.kotlin.services.imagebuilder.model.OutputResources? = null
        /**
         * The owner of the image.
         */
        public var owner: kotlin.String? = null
        /**
         * The platform of the image.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The state of the image.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.ImageState? = null
        /**
         * The tags of the image.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies whether this is an AMI or container image.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ImageType? = null
        /**
         * The version of the image.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImageSummary) : this() {
            this.arn = x.arn
            this.buildType = x.buildType
            this.dateCreated = x.dateCreated
            this.name = x.name
            this.osVersion = x.osVersion
            this.outputResources = x.outputResources
            this.owner = x.owner
            this.platform = x.platform
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImageSummary = ImageSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.OutputResources] inside the given [block]
         */
        public fun outputResources(block: aws.sdk.kotlin.services.imagebuilder.model.OutputResources.Builder.() -> kotlin.Unit) {
            this.outputResources = aws.sdk.kotlin.services.imagebuilder.model.OutputResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.ImageState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.ImageState.invoke(block)
        }
    }
}
