// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



public class ImportComponentRequest private constructor(builder: Builder) {
    /**
     * The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.
     */
    public val changeDescription: kotlin.String? = builder.changeDescription
    /**
     * The idempotency token of the component.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The data of the component. Used to specify the data inline. Either `data` or `uri` can be used to specify the data within the component.
     */
    public val data: kotlin.String? = builder.data
    /**
     * The description of the component. Describes the contents of the component.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The format of the resource that you want to import as a component.
     */
    public val format: aws.sdk.kotlin.services.imagebuilder.model.ComponentFormat? = builder.format
    /**
     * The ID of the KMS key that should be used to encrypt this component.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform of the component.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * The semantic version of the component. This version follows the semantic version syntax.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * The tags of the component.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the component denotes whether the component is used to build the image, or only to test it.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = builder.type
    /**
     * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either `data` or `uri` can be used to specify the data within the component.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportComponentRequest(")
        append("changeDescription=$changeDescription,")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("description=$description,")
        append("format=$format,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("platform=$platform,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("type=$type,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeDescription?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportComponentRequest

        if (changeDescription != other.changeDescription) return false
        if (clientToken != other.clientToken) return false
        if (data != other.data) return false
        if (description != other.description) return false
        if (format != other.format) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.
         */
        public var changeDescription: kotlin.String? = null
        /**
         * The idempotency token of the component.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The data of the component. Used to specify the data inline. Either `data` or `uri` can be used to specify the data within the component.
         */
        public var data: kotlin.String? = null
        /**
         * The description of the component. Describes the contents of the component.
         */
        public var description: kotlin.String? = null
        /**
         * The format of the resource that you want to import as a component.
         */
        public var format: aws.sdk.kotlin.services.imagebuilder.model.ComponentFormat? = null
        /**
         * The ID of the KMS key that should be used to encrypt this component.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * The platform of the component.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The semantic version of the component. This version follows the semantic version syntax.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * The tags of the component.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the component denotes whether the component is used to build the image, or only to test it.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = null
        /**
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either `data` or `uri` can be used to specify the data within the component.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest) : this() {
            this.changeDescription = x.changeDescription
            this.clientToken = x.clientToken
            this.data = x.data
            this.description = x.description
            this.format = x.format
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.platform = x.platform
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.type = x.type
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ImportComponentRequest = ImportComponentRequest(this)
    }
}
