// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Details of the infrastructure configuration.
 */
public class InfrastructureConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date on which the infrastructure configuration was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The date on which the infrastructure configuration was last updated.
     */
    public val dateUpdated: kotlin.String? = builder.dateUpdated
    /**
     * The description of the infrastructure configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The instance metadata option settings for the infrastructure configuration.
     */
    public val instanceMetadataOptions: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions? = builder.instanceMetadataOptions
    /**
     * The instance profile of the infrastructure configuration.
     */
    public val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The Amazon EC2 key pair of the infrastructure configuration.
     */
    public val keyPair: kotlin.String? = builder.keyPair
    /**
     * The logging configuration of the infrastructure configuration.
     */
    public val logging: aws.sdk.kotlin.services.imagebuilder.model.Logging? = builder.logging
    /**
     * The name of the infrastructure configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags attached to the resource created by Image Builder.
     */
    public val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The security group IDs of the infrastructure configuration.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
     *
     * EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The subnet ID of the infrastructure configuration.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The tags of the infrastructure configuration.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The terminate instance on failure configuration of the infrastructure configuration.
     */
    public val terminateInstanceOnFailure: kotlin.Boolean? = builder.terminateInstanceOnFailure

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InfrastructureConfiguration(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("instanceMetadataOptions=$instanceMetadataOptions,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("keyPair=$keyPair,")
        append("logging=$logging,")
        append("name=$name,")
        append("resourceTags=$resourceTags,")
        append("securityGroupIds=$securityGroupIds,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("terminateInstanceOnFailure=$terminateInstanceOnFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceMetadataOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (terminateInstanceOnFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InfrastructureConfiguration

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (instanceMetadataOptions != other.instanceMetadataOptions) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (keyPair != other.keyPair) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (resourceTags != other.resourceTags) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (terminateInstanceOnFailure != other.terminateInstanceOnFailure) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The date on which the infrastructure configuration was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        public var dateUpdated: kotlin.String? = null
        /**
         * The description of the infrastructure configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The instance metadata option settings for the infrastructure configuration.
         */
        public var instanceMetadataOptions: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions? = null
        /**
         * The instance profile of the infrastructure configuration.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The instance types of the infrastructure configuration.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The Amazon EC2 key pair of the infrastructure configuration.
         */
        public var keyPair: kotlin.String? = null
        /**
         * The logging configuration of the infrastructure configuration.
         */
        public var logging: aws.sdk.kotlin.services.imagebuilder.model.Logging? = null
        /**
         * The name of the infrastructure configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The tags attached to the resource created by Image Builder.
         */
        public var resourceTags: Map<String, String>? = null
        /**
         * The security group IDs of the infrastructure configuration.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
         *
         * EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The subnet ID of the infrastructure configuration.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The tags of the infrastructure configuration.
         */
        public var tags: Map<String, String>? = null
        /**
         * The terminate instance on failure configuration of the infrastructure configuration.
         */
        public var terminateInstanceOnFailure: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.instanceMetadataOptions = x.instanceMetadataOptions
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.keyPair = x.keyPair
            this.logging = x.logging
            this.name = x.name
            this.resourceTags = x.resourceTags
            this.securityGroupIds = x.securityGroupIds
            this.snsTopicArn = x.snsTopicArn
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.terminateInstanceOnFailure = x.terminateInstanceOnFailure
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration = InfrastructureConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions] inside the given [block]
         */
        public fun instanceMetadataOptions(block: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.instanceMetadataOptions = aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.imagebuilder.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.imagebuilder.model.Logging.invoke(block)
        }
    }
}
