// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.paginators

import aws.sdk.kotlin.services.imagebuilder.ImagebuilderClient
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListComponentBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentBuildVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentBuildVersionsResponse]
 */
public fun ImagebuilderClient.listComponentBuildVersionsPaginated(initialRequest: ListComponentBuildVersionsRequest): Flow<ListComponentBuildVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentBuildVersionsPaginated.listComponentBuildVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentBuildVersionsResponse]
 */
public fun ImagebuilderClient.listComponentBuildVersionsPaginated(block: ListComponentBuildVersionsRequest.Builder.() -> Unit): Flow<ListComponentBuildVersionsResponse> =
    listComponentBuildVersionsPaginated(ListComponentBuildVersionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ImagebuilderClient.listComponentsPaginated(initialRequest: ListComponentsRequest): Flow<ListComponentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentsPaginated.listComponents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ImagebuilderClient.listComponentsPaginated(block: ListComponentsRequest.Builder.() -> Unit): Flow<ListComponentsResponse> =
    listComponentsPaginated(ListComponentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListContainerRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContainerRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerRecipesResponse]
 */
public fun ImagebuilderClient.listContainerRecipesPaginated(initialRequest: ListContainerRecipesRequest): Flow<ListContainerRecipesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContainerRecipesPaginated.listContainerRecipes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContainerRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerRecipesResponse]
 */
public fun ImagebuilderClient.listContainerRecipesPaginated(block: ListContainerRecipesRequest.Builder.() -> Unit): Flow<ListContainerRecipesResponse> =
    listContainerRecipesPaginated(ListContainerRecipesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDistributionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDistributionConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionConfigurationsResponse]
 */
public fun ImagebuilderClient.listDistributionConfigurationsPaginated(initialRequest: ListDistributionConfigurationsRequest): Flow<ListDistributionConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDistributionConfigurationsPaginated.listDistributionConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDistributionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionConfigurationsResponse]
 */
public fun ImagebuilderClient.listDistributionConfigurationsPaginated(block: ListDistributionConfigurationsRequest.Builder.() -> Unit): Flow<ListDistributionConfigurationsResponse> =
    listDistributionConfigurationsPaginated(ListDistributionConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImageBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageBuildVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageBuildVersionsResponse]
 */
public fun ImagebuilderClient.listImageBuildVersionsPaginated(initialRequest: ListImageBuildVersionsRequest): Flow<ListImageBuildVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageBuildVersionsPaginated.listImageBuildVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImageBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageBuildVersionsResponse]
 */
public fun ImagebuilderClient.listImageBuildVersionsPaginated(block: ListImageBuildVersionsRequest.Builder.() -> Unit): Flow<ListImageBuildVersionsResponse> =
    listImageBuildVersionsPaginated(ListImageBuildVersionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImagePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePackagesResponse]
 */
public fun ImagebuilderClient.listImagePackagesPaginated(initialRequest: ListImagePackagesRequest): Flow<ListImagePackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePackagesPaginated.listImagePackages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePackagesResponse]
 */
public fun ImagebuilderClient.listImagePackagesPaginated(block: ListImagePackagesRequest.Builder.() -> Unit): Flow<ListImagePackagesResponse> =
    listImagePackagesPaginated(ListImagePackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImagePipelineImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePipelineImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelineImagesResponse]
 */
public fun ImagebuilderClient.listImagePipelineImagesPaginated(initialRequest: ListImagePipelineImagesRequest): Flow<ListImagePipelineImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePipelineImagesPaginated.listImagePipelineImages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePipelineImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelineImagesResponse]
 */
public fun ImagebuilderClient.listImagePipelineImagesPaginated(block: ListImagePipelineImagesRequest.Builder.() -> Unit): Flow<ListImagePipelineImagesResponse> =
    listImagePipelineImagesPaginated(ListImagePipelineImagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImagePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelinesResponse]
 */
public fun ImagebuilderClient.listImagePipelinesPaginated(initialRequest: ListImagePipelinesRequest): Flow<ListImagePipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePipelinesPaginated.listImagePipelines(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelinesResponse]
 */
public fun ImagebuilderClient.listImagePipelinesPaginated(block: ListImagePipelinesRequest.Builder.() -> Unit): Flow<ListImagePipelinesResponse> =
    listImagePipelinesPaginated(ListImagePipelinesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImageRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageRecipesResponse]
 */
public fun ImagebuilderClient.listImageRecipesPaginated(initialRequest: ListImageRecipesRequest): Flow<ListImageRecipesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageRecipesPaginated.listImageRecipes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImageRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageRecipesResponse]
 */
public fun ImagebuilderClient.listImageRecipesPaginated(block: ListImageRecipesRequest.Builder.() -> Unit): Flow<ListImageRecipesResponse> =
    listImageRecipesPaginated(ListImageRecipesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun ImagebuilderClient.listImagesPaginated(initialRequest: ListImagesRequest): Flow<ListImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagesPaginated.listImages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun ImagebuilderClient.listImagesPaginated(block: ListImagesRequest.Builder.() -> Unit): Flow<ListImagesResponse> =
    listImagesPaginated(ListImagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListInfrastructureConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInfrastructureConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInfrastructureConfigurationsResponse]
 */
public fun ImagebuilderClient.listInfrastructureConfigurationsPaginated(initialRequest: ListInfrastructureConfigurationsRequest): Flow<ListInfrastructureConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInfrastructureConfigurationsPaginated.listInfrastructureConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInfrastructureConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInfrastructureConfigurationsResponse]
 */
public fun ImagebuilderClient.listInfrastructureConfigurationsPaginated(block: ListInfrastructureConfigurationsRequest.Builder.() -> Unit): Flow<ListInfrastructureConfigurationsResponse> =
    listInfrastructureConfigurationsPaginated(ListInfrastructureConfigurationsRequest.Builder().apply(block).build())
