// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.imagebuilder.model.DistributionConfigurationSummary
import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListDistributionConfigurationsOperationDeserializer: HttpDeserialize<ListDistributionConfigurationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDistributionConfigurationsResponse {
        if (!response.status.isSuccess()) {
            throwListDistributionConfigurationsError(context, response)
        }
        val builder = ListDistributionConfigurationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDistributionConfigurationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDistributionConfigurationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDistributionConfigurationsOperationBody(builder: ListDistributionConfigurationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISTRIBUTIONCONFIGURATIONSUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("distributionConfigurationSummaryList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISTRIBUTIONCONFIGURATIONSUMMARYLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISTRIBUTIONCONFIGURATIONSUMMARYLIST_DESCRIPTOR.index -> builder.distributionConfigurationSummaryList =
                    deserializer.deserializeList(DISTRIBUTIONCONFIGURATIONSUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<DistributionConfigurationSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDistributionConfigurationSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
